/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.msgpack.query;

import io.zeebe.msgpack.jsonpath.JsonPathQuery;
import io.zeebe.msgpack.query.MsgPackQueryExecutor;
import io.zeebe.msgpack.query.MsgPackTraverser;
import io.zeebe.msgpack.spec.MsgPackReader;
import io.zeebe.msgpack.spec.MsgPackToken;
import io.zeebe.msgpack.spec.MsgPackType;
import org.agrona.DirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

public class MsgPackQueryProcessor {
    private final MsgPackQueryExecutor queryExecutor = new MsgPackQueryExecutor();
    private final MsgPackTraverser traverser = new MsgPackTraverser();
    private final MsgPackReader reader = new MsgPackReader();
    private final QueryResults results = new QueryResults();
    private final QueryResult result = new QueryResult();

    public QueryResults process(JsonPathQuery query, DirectBuffer data) {
        this.queryExecutor.init(query.getFilters(), query.getFilterInstances());
        this.traverser.wrap(data, 0, data.capacity());
        this.traverser.traverse(this.queryExecutor);
        this.results.wrap(data);
        return this.results;
    }

    public class QueryResult {
        private final UnsafeBuffer longResultBuffer = new UnsafeBuffer();
        private MsgPackToken token;

        private void wrap(MsgPackToken token) {
            this.token = token;
        }

        public boolean isString() {
            return this.token.getType() == MsgPackType.STRING;
        }

        public boolean isLong() {
            return this.token.getType() == MsgPackType.INTEGER;
        }

        public DirectBuffer getString() {
            if (!this.isString()) {
                throw new RuntimeException(String.format("expected String but found '%s'", this.token.getType()));
            }
            return this.token.getValueBuffer();
        }

        public DirectBuffer getLongAsString() {
            if (!this.isLong()) {
                throw new RuntimeException(String.format("expected Long but found '%s'", this.token.getType()));
            }
            long key = this.token.getIntegerValue();
            String converted = String.valueOf(key);
            this.longResultBuffer.wrap(converted.getBytes());
            return this.longResultBuffer;
        }
    }

    public class QueryResults {
        private DirectBuffer data;

        private void wrap(DirectBuffer data) {
            this.data = data;
        }

        public int size() {
            return MsgPackQueryProcessor.this.queryExecutor.numResults();
        }

        public QueryResult getSingleResult() {
            if (this.size() == 1) {
                MsgPackQueryProcessor.this.result.wrap(this.readToken(0));
                return MsgPackQueryProcessor.this.result;
            }
            if (this.size() == 0) {
                throw new RuntimeException("no result found");
            }
            throw new RuntimeException("found more than one result");
        }

        private MsgPackToken readToken(int index) {
            MsgPackQueryProcessor.this.queryExecutor.moveToResult(index);
            MsgPackQueryProcessor.this.reader.wrap(this.data, MsgPackQueryProcessor.this.queryExecutor.currentResultPosition(), MsgPackQueryProcessor.this.queryExecutor.currentResultLength());
            return MsgPackQueryProcessor.this.reader.readToken();
        }
    }
}

