/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.msgpack.query;

import io.zeebe.msgpack.query.AbstractDynamicContext;

public class MsgPackTraversalContext
extends AbstractDynamicContext {
    protected static final int CURRENT_ELEMENT_OFFSET = 0;
    protected static final int NUM_ELEMENTS_OFFSET = 4;
    protected static final int APPLYING_FILTER_OFFSET = 8;
    protected static final int CONTAINER_TYPE_OFFSET = 12;
    protected static final int STATIC_ELEMENT_SIZE = 16;

    public MsgPackTraversalContext(int maxTraversalDepth, int dynamicContextSize) {
        super(maxTraversalDepth, 16, dynamicContextSize);
    }

    public int currentElement() {
        return this.cursorView.getInt(0);
    }

    public void currentElement(int newValue) {
        this.cursorView.putInt(0, newValue);
    }

    public int numElements() {
        return this.cursorView.getInt(4);
    }

    public void numElements(int newValue) {
        this.cursorView.putInt(4, newValue);
    }

    public int applyingFilter() {
        return this.cursorView.getInt(8);
    }

    public void applyingFilter(int newValue) {
        this.cursorView.putInt(8, newValue);
    }

    public boolean isMap() {
        return this.cursorView.getInt(12) == 0;
    }

    public void setIsMap(boolean isMap) {
        this.cursorView.putInt(12, isMap ? 0 : 1);
    }
}

