/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.util;

import java.util.Arrays;

public enum ByteUnit {
    BYTES(0.0, ""),
    KILOBYTES(1.0, "K"),
    MEGABYTES(2.0, "M"),
    GIGABYTES(3.0, "G");

    private final double unitFactor;
    private final String metric;

    private ByteUnit(double factor, String metric) {
        this.unitFactor = factor;
        this.metric = metric;
    }

    public long toBytes(long value) {
        double methodFactor = 0.0;
        return this.calculateValue(value, 0.0);
    }

    public long toKilobytes(long value) {
        double methodFactor = 1.0;
        return this.calculateValue(value, 1.0);
    }

    public long toMegabytes(long value) {
        double methodFactor = 2.0;
        return this.calculateValue(value, 2.0);
    }

    public long toGigabytes(long value) {
        double methodFactor = 3.0;
        return this.calculateValue(value, 3.0);
    }

    private long calculateValue(long value, double methodFactor) {
        if (this.unitFactor < methodFactor) {
            return value / (long)Math.pow(1024.0, methodFactor - this.unitFactor);
        }
        if (this.unitFactor == methodFactor) {
            return value;
        }
        return value * (long)Math.pow(1024.0, this.unitFactor - methodFactor);
    }

    public static ByteUnit getUnit(String unitString) {
        return Arrays.stream(ByteUnit.values()).filter(unit -> unit.metric.equalsIgnoreCase(unitString)).findAny().orElse(BYTES);
    }

    public String metric() {
        return this.metric;
    }
}

