/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.util;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.agrona.concurrent.ManyToOneConcurrentLinkedQueue;

public class DeferredCommandContext {
    protected final ManyToOneConcurrentLinkedQueue<Runnable> cmdQueue;
    protected final Consumer<Runnable> cmdConsumer = Runnable::run;

    public DeferredCommandContext() {
        this.cmdQueue = new ManyToOneConcurrentLinkedQueue();
    }

    public <T> CompletableFuture<T> runAsync(Consumer<CompletableFuture<T>> action) {
        CompletableFuture future = new CompletableFuture();
        this.cmdQueue.add(() -> {
            try {
                action.accept(future);
            }
            catch (Exception e) {
                future.completeExceptionally(e);
            }
        });
        return future;
    }

    public void runAsync(Runnable r) {
        this.cmdQueue.add((Object)r);
    }

    public void doWork() {
        while (!this.cmdQueue.isEmpty()) {
            Runnable runnable = (Runnable)this.cmdQueue.poll();
            if (runnable == null) continue;
            this.cmdConsumer.accept(runnable);
        }
    }
}

