/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.util;

import io.zeebe.util.Loggers;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileStore;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import org.agrona.LangUtil;
import org.slf4j.Logger;

public class FileUtil {
    public static final Logger LOG = Loggers.FILE_LOGGER;

    public static void closeSilently(Closeable out) {
        if (out != null) {
            try {
                out.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void deleteFolder(String path) throws IOException {
        Path directory = Paths.get(path, new String[0]);
        FileUtil.deleteFolder(directory);
    }

    public static void deleteFolder(Path directory) throws IOException {
        Files.walkFileTree(directory, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                Files.delete(dir);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    public static long getAvailableSpace(File logLocation) {
        long usableSpace = -1L;
        try {
            FileStore fileStore = Files.getFileStore(logLocation.toPath());
            usableSpace = fileStore.getUsableSpace();
        }
        catch (IOException e) {
            LangUtil.rethrowUnchecked((Throwable)e);
        }
        return usableSpace;
    }

    public static FileChannel openChannel(String filename, boolean create) {
        FileChannel fileChannel = null;
        try {
            File file = new File(filename);
            if (!file.exists()) {
                if (create) {
                    file.getParentFile().mkdirs();
                    file.createNewFile();
                } else {
                    return null;
                }
            }
            RandomAccessFile raf = new RandomAccessFile(file, "rw");
            fileChannel = raf.getChannel();
        }
        catch (Exception e) {
            LangUtil.rethrowUnchecked((Throwable)e);
        }
        return fileChannel;
    }

    public static void moveFile(String source, String target, CopyOption ... options) {
        Path sourcePath = Paths.get(source, new String[0]);
        Path targetPath = Paths.get(target, new String[0]);
        try {
            Files.move(sourcePath, targetPath, options);
        }
        catch (Exception e) {
            LangUtil.rethrowUnchecked((Throwable)e);
        }
    }

    public static void replace(Path src, Path dest) throws IOException {
        try {
            Files.move(src, dest, StandardCopyOption.ATOMIC_MOVE);
        }
        catch (Exception e) {
            Files.move(src, dest, StandardCopyOption.REPLACE_EXISTING);
        }
    }

    public static void deleteFile(File file) {
        if (file.exists() && !file.delete()) {
            LOG.warn("Failed to delete file '{}'", (Object)file);
        }
    }

    public static void copySnapshot(File runtimeDirectory, File snapshotDirectory) throws Exception {
        Path targetPath = runtimeDirectory.toPath();
        Path sourcePath = snapshotDirectory.toPath();
        Files.walkFileTree(sourcePath, new SnapshotCopier(sourcePath, targetPath));
    }

    public static final class SnapshotCopier
    extends SimpleFileVisitor<Path> {
        private final Path targetPath;
        private final Path sourcePath;

        SnapshotCopier(Path sourcePath, Path targetPath) {
            this.sourcePath = sourcePath;
            this.targetPath = targetPath;
        }

        @Override
        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
            Path newDirectory = this.targetPath.resolve(this.sourcePath.relativize(dir));
            try {
                Files.copy(dir, newDirectory, new CopyOption[0]);
            }
            catch (FileAlreadyExistsException ioException) {
                LOG.error("Problem on copying snapshot to runtime.", (Throwable)ioException);
                return FileVisitResult.SKIP_SUBTREE;
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
            Path newFile = this.targetPath.resolve(this.sourcePath.relativize(file));
            try {
                Files.copy(file, newFile, new CopyOption[0]);
            }
            catch (IOException ioException) {
                LOG.error("Problem on copying {} to {}.", new Object[]{file, newFile, ioException});
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult postVisitDirectory(Path dir, IOException exc) {
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFileFailed(Path file, IOException exc) {
            LOG.error("Problem on copying snapshot to runtime.", (Throwable)exc);
            return FileVisitResult.CONTINUE;
        }
    }
}

