/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.util;

import io.zeebe.util.StringUtil;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.agrona.BitUtil;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;

public class StreamUtil {
    protected static final int DEFAULT_BUFFER_SIZE = 4096;

    public static MessageDigest getDigest(String algorithm) {
        try {
            return MessageDigest.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
    }

    public static MessageDigest getSha1Digest() {
        return StreamUtil.getDigest("SHA1");
    }

    public static MessageDigest updateDigest(MessageDigest messageDigest, InputStream data) throws IOException {
        int n;
        byte[] buffer = new byte[4096];
        while ((n = data.read(buffer)) > -1) {
            messageDigest.update(buffer, 0, n);
        }
        return messageDigest;
    }

    public static String sha1Hex(InputStream data) throws IOException {
        MessageDigest messageDigest = StreamUtil.updateDigest(StreamUtil.getSha1Digest(), data);
        return StreamUtil.digestAsHex(messageDigest);
    }

    public static String digestAsHex(MessageDigest messageDigest) {
        byte[] digest = messageDigest.digest();
        byte[] hexByteArray = BitUtil.toHexByteArray((byte[])digest);
        return StringUtil.fromBytes(hexByteArray);
    }

    public static int copy(InputStream input, OutputStream output) throws IOException {
        int n;
        byte[] buffer = new byte[4096];
        int count = 0;
        while ((n = input.read(buffer)) > -1) {
            output.write(buffer, 0, n);
            count += n;
        }
        return count;
    }

    public static void write(File file, String data) throws IOException {
        try (FileOutputStream os = new FileOutputStream(file);){
            os.write(StringUtil.getBytes(data));
        }
    }

    public static void write(File file, InputStream data, MessageDigest messageDigest) throws IOException {
        try (DigestOutputStream os = new DigestOutputStream(new FileOutputStream(file), messageDigest);){
            StreamUtil.copy(data, os);
        }
        String digest = StreamUtil.digestAsHex(messageDigest);
        String fileName = file.getName();
        String content = String.format("%s %s", digest, fileName);
        String algorithm = messageDigest.getAlgorithm().toLowerCase();
        String targetFileName = String.format("%s.%s", file.getAbsolutePath(), algorithm);
        StreamUtil.write(new File(targetFileName), content);
    }

    public static int read(InputStream input, byte[] dst) throws IOException {
        return StreamUtil.read(input, dst, 0);
    }

    public static int read(InputStream input, MutableDirectBuffer buffer, int offset) throws IOException {
        int bytesRead;
        if (buffer.byteArray() == null) {
            throw new RuntimeException("Cannot be used with direct byte buffers");
        }
        int writeOffset = offset;
        do {
            buffer.checkLimit(offset + 4096);
            bytesRead = input.read(buffer.byteArray(), writeOffset, 4096);
            if (bytesRead <= 0) continue;
            writeOffset += bytesRead;
        } while (bytesRead >= 0);
        return writeOffset - offset;
    }

    public static int read(InputStream input, byte[] dst, int offset) throws IOException {
        int count;
        int remaining = dst.length - offset;
        int location = offset;
        while (remaining > 0 && (count = input.read(dst, location, remaining)) != -1) {
            remaining -= count;
            location += count;
        }
        return location - offset;
    }

    public static byte[] read(InputStream input) throws IOException {
        byte[] byteBuffer = new byte[4096];
        try (ByteArrayOutputStream buffer = new ByteArrayOutputStream();){
            int readBytes;
            while ((readBytes = input.read(byteBuffer, 0, byteBuffer.length)) != -1) {
                buffer.write(byteBuffer, 0, readBytes);
            }
            buffer.flush();
            byte[] byArray = buffer.toByteArray();
            return byArray;
        }
    }

    public static void write(DirectBuffer source, OutputStream destination) throws IOException {
        StreamUtil.write(source, destination, 0, source.capacity());
    }

    public static void write(DirectBuffer source, OutputStream destination, int offset, int length) throws IOException {
        int realOffset = source.wrapAdjustment() + offset;
        if (source.byteArray() != null) {
            destination.write(source.byteArray(), realOffset, length);
        } else {
            WritableByteChannel channel = Channels.newChannel(destination);
            ByteBuffer writeBuffer = source.byteBuffer().asReadOnlyBuffer();
            writeBuffer.position(realOffset);
            writeBuffer.limit(realOffset + length);
            channel.write(writeBuffer);
        }
    }

    public static void writeLong(OutputStream outputStream, long longValue) throws IOException {
        outputStream.write((byte)longValue);
        outputStream.write((byte)(longValue >>> 8));
        outputStream.write((byte)(longValue >>> 16));
        outputStream.write((byte)(longValue >>> 24));
        outputStream.write((byte)(longValue >>> 32));
        outputStream.write((byte)(longValue >>> 40));
        outputStream.write((byte)(longValue >>> 48));
        outputStream.write((byte)(longValue >>> 56));
    }

    public static long readLong(InputStream inputStream) throws IOException {
        long value = inputStream.read();
        value += (long)inputStream.read() << 8;
        value += (long)inputStream.read() << 16;
        value += (long)inputStream.read() << 24;
        value += (long)inputStream.read() << 32;
        value += (long)inputStream.read() << 40;
        value += (long)inputStream.read() << 48;
        return value += (long)inputStream.read() << 56;
    }
}

