/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.util.buffer;

import io.zeebe.util.EnsureUtil;
import io.zeebe.util.StringUtil;
import io.zeebe.util.buffer.BufferReader;
import io.zeebe.util.buffer.BufferWriter;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import org.agrona.DirectBuffer;
import org.agrona.ExpandableArrayBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

public final class BufferUtil {
    public static final int NO_WRAP = 1;
    public static final int DEFAULT_WRAP = 16;
    private static final char[] HEX_CODE = "0123456789ABCDEF".toCharArray();

    private BufferUtil() {
    }

    public static String bufferAsString(DirectBuffer buffer) {
        return BufferUtil.bufferAsString(buffer, 0, buffer.capacity());
    }

    public static String bufferAsString(DirectBuffer buffer, int offset, int length) {
        byte[] bytes = new byte[length];
        buffer.getBytes(offset, bytes);
        return new String(bytes, StandardCharsets.UTF_8);
    }

    public static DirectBuffer wrapString(String argument) {
        return new UnsafeBuffer(StringUtil.getBytes(argument));
    }

    public static boolean equals(DirectBuffer buffer1, DirectBuffer buffer2) {
        if (buffer1 instanceof UnsafeBuffer && buffer2 instanceof UnsafeBuffer) {
            return buffer1.equals(buffer2);
        }
        if (buffer1 instanceof ExpandableArrayBuffer && buffer2 instanceof ExpandableArrayBuffer) {
            return buffer1.equals(buffer2);
        }
        return BufferUtil.contentsEqual(buffer1, buffer2);
    }

    public static boolean contentsEqual(DirectBuffer buffer1, DirectBuffer buffer2) {
        if (buffer1.capacity() == buffer2.capacity()) {
            boolean equal = true;
            for (int i = 0; i < buffer1.capacity() && equal; equal &= buffer1.getByte(i) == buffer2.getByte(i), ++i) {
            }
            return equal;
        }
        return false;
    }

    public static DirectBuffer cloneBuffer(DirectBuffer src) {
        return BufferUtil.cloneBuffer(src, 0, src.capacity());
    }

    public static DirectBuffer cloneBuffer(DirectBuffer src, int offset, int length) {
        int availableBytes = src.capacity() - offset;
        EnsureUtil.ensureGreaterThanOrEqual("available bytes", availableBytes, length);
        if (src instanceof UnsafeBuffer) {
            byte[] dst = new byte[length];
            src.getBytes(offset, dst);
            return new UnsafeBuffer(dst);
        }
        if (src instanceof ExpandableArrayBuffer) {
            ExpandableArrayBuffer dst = new ExpandableArrayBuffer(length);
            src.getBytes(offset, (MutableDirectBuffer)dst, 0, length);
            return dst;
        }
        throw new RuntimeException("Unable to clone buffer of class " + src.getClass().getSimpleName());
    }

    public static String bufferAsHexString(BufferWriter writer) {
        return BufferUtil.bufferAsHexString(writer, 16);
    }

    public static String bufferAsHexString(BufferWriter writer, int wrap) {
        byte[] bytes = new byte[writer.getLength()];
        UnsafeBuffer buffer = new UnsafeBuffer(bytes);
        writer.write((MutableDirectBuffer)buffer, 0);
        return BufferUtil.bytesAsHexString(bytes, wrap);
    }

    public static String bufferAsHexString(DirectBuffer buffer) {
        return BufferUtil.bufferAsHexString(buffer, 16);
    }

    public static String bufferAsHexString(DirectBuffer buffer, int wrap) {
        return BufferUtil.bufferAsHexString(buffer, 0, buffer.capacity(), wrap);
    }

    public static String bufferAsHexString(DirectBuffer buffer, int offset, int length) {
        return BufferUtil.bufferAsHexString(buffer, offset, length, 16);
    }

    public static String bufferAsHexString(DirectBuffer buffer, int offset, int length, int wrap) {
        byte[] bytes = new byte[length];
        buffer.getBytes(offset, bytes, 0, length);
        return BufferUtil.bytesAsHexString(bytes, wrap);
    }

    public static String bytesAsHexString(byte[] bytes) {
        return BufferUtil.bytesAsHexString(bytes, 16);
    }

    public static String bytesAsHexString(byte[] bytes, int wrap) {
        int length = bytes.length;
        StringBuilder builder = new StringBuilder(length * 4);
        StringBuilder hexBuilder = new StringBuilder(wrap * 3);
        StringBuilder asciiBuilder = new StringBuilder(wrap);
        for (int line = 0; line <= length / wrap; ++line) {
            builder.append(String.format("0x%08x: ", line * wrap));
            for (int i = 0; i < wrap; ++i) {
                int index = line * wrap + i;
                if (index < length) {
                    byte b = bytes[index];
                    hexBuilder.append(HEX_CODE[b >> 4 & 0xF]).append(HEX_CODE[b & 0xF]).append(' ');
                    if (b > 31 && b < 126) {
                        asciiBuilder.append((char)b);
                        continue;
                    }
                    asciiBuilder.append('.');
                    continue;
                }
                hexBuilder.append("   ");
            }
            builder.append(hexBuilder.toString()).append('|').append(asciiBuilder.toString()).append("|\n");
            asciiBuilder.delete(0, asciiBuilder.length());
            hexBuilder.delete(0, hexBuilder.length());
        }
        return builder.toString();
    }

    public static byte[] bufferAsArray(DirectBuffer buffer) {
        byte[] array = new byte[buffer.capacity()];
        buffer.getBytes(0, array);
        return array;
    }

    public static MutableDirectBuffer wrapArray(byte[] array) {
        return new UnsafeBuffer(array);
    }

    public static MutableDirectBuffer wrapBytes(int ... bytes) {
        return new UnsafeBuffer(BufferUtil.intArrayToByteArray(bytes));
    }

    public static int bufferContentsHash(DirectBuffer buffer) {
        int hashCode = 1;
        int length = buffer.capacity();
        for (int i = 0; i < length; ++i) {
            hashCode = 31 * hashCode + buffer.getByte(i);
        }
        return hashCode;
    }

    public static boolean startsWith(byte[] prefix, int prefixOffset, int prefixLength, byte[] content, int contentOffset, int contentLength) {
        if (contentLength < prefixLength) {
            return false;
        }
        int i = prefixOffset;
        while (i < prefixLength) {
            if (content[contentOffset] != prefix[i]) {
                return false;
            }
            ++i;
            ++contentOffset;
        }
        return true;
    }

    protected static byte[] intArrayToByteArray(int[] input) {
        byte[] result = new byte[input.length];
        for (int i = 0; i < input.length; ++i) {
            result[i] = (byte)input[i];
        }
        return result;
    }

    public static int readIntoBuffer(DirectBuffer buffer, int offset, DirectBuffer valueBuffer) {
        int length = buffer.getInt(offset, ByteOrder.LITTLE_ENDIAN);
        byte[] bytes = new byte[length];
        valueBuffer.wrap(bytes);
        buffer.getBytes(offset += 4, bytes, 0, length);
        return offset += length;
    }

    public static int writeIntoBuffer(MutableDirectBuffer writeBuffer, int offset, DirectBuffer valueBuffer) {
        int valueLength = valueBuffer.capacity();
        writeBuffer.putInt(offset, valueLength, ByteOrder.LITTLE_ENDIAN);
        writeBuffer.putBytes(offset += 4, valueBuffer, 0, valueLength);
        return offset += valueLength;
    }

    public static int writeIntoBuffer(MutableDirectBuffer writeBuffer, int offset, BufferWriter value) {
        int valueLength = value.getLength();
        writeBuffer.putInt(offset, valueLength, ByteOrder.LITTLE_ENDIAN);
        value.write(writeBuffer, offset += 4);
        return offset + valueLength;
    }

    public static int readIntoBuffer(DirectBuffer readBuffer, int offset, BufferReader reader) {
        int valueLength = readBuffer.getInt(offset, ByteOrder.LITTLE_ENDIAN);
        reader.wrap(readBuffer, offset += 4, valueLength);
        return offset + valueLength;
    }
}

