/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.util.buffer;

import io.zeebe.util.buffer.BufferWriter;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;

public class DirectBufferWriter
implements BufferWriter {
    protected DirectBuffer buffer;
    protected int offset;
    protected int length;

    @Override
    public int getLength() {
        return this.length;
    }

    @Override
    public void write(MutableDirectBuffer writeBuffer, int writeOffset) {
        writeBuffer.putBytes(writeOffset, this.buffer, this.offset, this.length);
    }

    public DirectBufferWriter wrap(DirectBuffer buffer, int offset, int length) {
        this.buffer = buffer;
        this.offset = offset;
        this.length = length;
        return this;
    }

    public DirectBufferWriter wrap(DirectBuffer buffer) {
        return this.wrap(buffer, 0, buffer.capacity());
    }

    public void reset() {
        this.buffer = null;
        this.offset = -1;
        this.length = 0;
    }

    public static DirectBufferWriter writerFor(DirectBuffer buffer) {
        return new DirectBufferWriter().wrap(buffer);
    }
}

