/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.util.cache;

import java.nio.ByteBuffer;
import java.util.function.LongFunction;
import org.agrona.DirectBuffer;
import org.agrona.ExpandableDirectByteBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

public class ExpandableBufferCache {
    private final DirectBuffer readBuffer = new UnsafeBuffer(0L, 0);
    private final long[] keys;
    private final MutableDirectBuffer[] values;
    private final LongFunction<DirectBuffer> lookup;
    private final int capacity;
    private int size;

    public ExpandableBufferCache(int cacheCapacity, int initialBufferCapacity, LongFunction<DirectBuffer> lookup) {
        this.capacity = cacheCapacity;
        this.lookup = lookup;
        this.size = 0;
        this.keys = new long[cacheCapacity];
        this.values = new MutableDirectBuffer[cacheCapacity];
        for (int i = 0; i < this.values.length; ++i) {
            this.values[i] = new ExpandableDirectByteBuffer(initialBufferCapacity);
        }
    }

    public DirectBuffer get(long key) {
        int index = this.indexOf(key);
        if (index >= 0) {
            MutableDirectBuffer value = this.values[index];
            this.makeMostRecent(key, value, index);
            ByteBuffer byteBuffer = value.byteBuffer();
            this.readBuffer.wrap(byteBuffer, 0, byteBuffer.limit());
            return this.readBuffer;
        }
        DirectBuffer buffer = this.lookup.apply(key);
        if (buffer != null) {
            this.insert(key, buffer);
        }
        return buffer;
    }

    private int indexOf(long key) {
        for (int i = 0; i < this.size; ++i) {
            if (this.keys[i] != key) continue;
            return i;
        }
        return -1;
    }

    private void insert(long key, DirectBuffer buffer) {
        MutableDirectBuffer value;
        if (this.size == this.capacity) {
            value = this.values[this.size - 1];
            if (buffer.capacity() < value.byteBuffer().limit()) {
                this.recycle(value);
            }
        } else {
            value = this.values[this.size];
            ++this.size;
        }
        this.copyBuffer(buffer, value);
        this.makeMostRecent(key, value, this.size - 1);
    }

    private void copyBuffer(DirectBuffer source, MutableDirectBuffer target) {
        source.getBytes(0, target, 0, source.capacity());
        target.byteBuffer().limit(source.capacity());
    }

    private void makeMostRecent(long key, MutableDirectBuffer value, int fromIndex) {
        for (int i = fromIndex; i > 0; --i) {
            this.keys[i] = this.keys[i - 1];
            this.values[i] = this.values[i - 1];
        }
        this.keys[0] = key;
        this.values[0] = value;
    }

    private void recycle(MutableDirectBuffer buffer) {
        buffer.setMemory(0, buffer.capacity(), (byte)0);
    }

    public void put(long key, DirectBuffer buffer) {
        int index = this.indexOf(key);
        if (index >= 0) {
            MutableDirectBuffer value = this.values[index];
            if (buffer.capacity() < value.byteBuffer().limit()) {
                this.recycle(value);
            }
            this.copyBuffer(buffer, value);
            this.makeMostRecent(key, value, index);
        } else {
            this.insert(key, buffer);
        }
    }

    public void remove(long key) {
        int index = this.indexOf(key);
        if (index >= 0) {
            MutableDirectBuffer value = this.values[index];
            this.recycle(value);
            --this.size;
            for (int i = index; i < this.size; ++i) {
                this.keys[i] = this.keys[i + 1];
                this.values[i] = this.values[i + 1];
            }
            this.keys[this.size] = 0L;
            this.values[this.size] = value;
        }
    }

    public int getSize() {
        return this.size;
    }

    public void clear() {
        for (int i = 0; i < this.size; ++i) {
            this.recycle(this.values[i]);
        }
        this.size = 0;
    }
}

