/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.util.collection;

import io.zeebe.util.collection.CompactList;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

public class CompactListIterator
implements Iterator<MutableDirectBuffer> {
    protected final CompactList values;
    protected final UnsafeBuffer current;
    protected int position;

    public CompactListIterator(CompactList values) {
        this.values = values;
        this.current = new UnsafeBuffer(new byte[values.maxElementDataLength()]);
        this.reset();
    }

    public void reset() {
        this.position = -1;
    }

    public int position() {
        return this.position;
    }

    @Override
    public boolean hasNext() {
        return this.position + 1 < this.values.size();
    }

    @Override
    public MutableDirectBuffer next() {
        if (this.position + 1 >= this.values.size()) {
            throw new NoSuchElementException();
        }
        ++this.position;
        this.values.wrap(this.position, (MutableDirectBuffer)this.current);
        return this.current;
    }
}

