/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.util.metrics;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Map;
import java.util.function.Consumer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.AtomicBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import org.agrona.concurrent.status.AtomicCounter;

public class Metric {
    private static final byte[] EMPTY = new byte[0];
    private static final byte[] DESCRIPTION_PREFIX = "# HELP".getBytes(StandardCharsets.UTF_8);
    private static final byte[] TYPE_PREFIX = "# TYPE".getBytes(StandardCharsets.UTF_8);
    private static final byte[] OPENING_CURLY_BRACE = "{".getBytes(StandardCharsets.UTF_8);
    private static final byte[] CLOSING_CURLY_BRACE = "}".getBytes(StandardCharsets.UTF_8);
    private static final byte[] NEW_LINE = "\n".getBytes(StandardCharsets.UTF_8);
    private static final byte[] DOUBLE_QUOTE = "\"".getBytes(StandardCharsets.UTF_8);
    private static final byte[] COMMA = ",".getBytes(StandardCharsets.UTF_8);
    private static final byte[] EQUALS = "=".getBytes(StandardCharsets.UTF_8);
    private static final byte[] WHITESPACE = " ".getBytes(StandardCharsets.UTF_8);
    private final AtomicCounter value;
    private final byte[] name;
    private final byte[] type;
    private final byte[] description;
    private final Label[] labels;
    private final Consumer<Metric> onClose;

    public Metric(String name, String type, String description, Map<String, String> labels, Consumer<Metric> onClose) {
        this.onClose = onClose;
        this.value = new AtomicCounter((AtomicBuffer)new UnsafeBuffer(new byte[8]), 0);
        this.name = name.getBytes(StandardCharsets.UTF_8);
        this.type = type.getBytes(StandardCharsets.UTF_8);
        this.description = description == null ? EMPTY : description.getBytes(StandardCharsets.UTF_8);
        this.labels = new Label[labels.size()];
        ArrayList<Map.Entry<String, String>> labelSet = new ArrayList<Map.Entry<String, String>>(labels.entrySet());
        for (int i = 0; i < labelSet.size(); ++i) {
            Map.Entry entry = (Map.Entry)labelSet.get(i);
            this.labels[i] = new Label((String)entry.getKey(), (String)entry.getValue());
        }
    }

    public long incrementOrdered() {
        return this.value.incrementOrdered();
    }

    public void setOrdered(long value) {
        this.value.setOrdered(value);
    }

    public long getWeak() {
        return this.value.getWeak();
    }

    public long get() {
        return this.value.get();
    }

    public int id() {
        return this.value.id();
    }

    public long getAndAddOrdered(long increment) {
        return this.value.getAndAddOrdered(increment);
    }

    public String getName() {
        return new String(this.name, StandardCharsets.UTF_8);
    }

    public int dump(MutableDirectBuffer buffer, int offset, long now) {
        if (this.description.length > 0) {
            offset = this.writeArray(buffer, offset, DESCRIPTION_PREFIX);
            offset = this.writeArray(buffer, offset, WHITESPACE);
            offset = this.writeArray(buffer, offset, this.name);
            offset = this.writeArray(buffer, offset, WHITESPACE);
            offset = this.writeArray(buffer, offset, this.description);
            offset = this.writeArray(buffer, offset, NEW_LINE);
        }
        offset = this.writeArray(buffer, offset, TYPE_PREFIX);
        offset = this.writeArray(buffer, offset, WHITESPACE);
        offset = this.writeArray(buffer, offset, this.name);
        offset = this.writeArray(buffer, offset, WHITESPACE);
        offset = this.writeArray(buffer, offset, this.type);
        offset = this.writeArray(buffer, offset, NEW_LINE);
        offset = this.writeArray(buffer, offset, this.name);
        offset = this.writeArray(buffer, offset, OPENING_CURLY_BRACE);
        for (int i = 0; i < this.labels.length; ++i) {
            if (i != 0) {
                offset = this.writeArray(buffer, offset, COMMA);
            }
            offset = this.writeArray(buffer, offset, this.labels[i].name);
            offset = this.writeArray(buffer, offset, EQUALS);
            offset = this.writeArray(buffer, offset, DOUBLE_QUOTE);
            offset = this.writeArray(buffer, offset, this.labels[i].value);
            offset = this.writeArray(buffer, offset, DOUBLE_QUOTE);
        }
        offset = this.writeArray(buffer, offset, CLOSING_CURLY_BRACE);
        offset = this.writeArray(buffer, offset, WHITESPACE);
        offset = this.writeArray(buffer, offset, Long.toString(this.value.get()).getBytes(StandardCharsets.UTF_8));
        offset = this.writeArray(buffer, offset, WHITESPACE);
        offset = this.writeArray(buffer, offset, Long.toString(now).getBytes(StandardCharsets.UTF_8));
        offset = this.writeArray(buffer, offset, NEW_LINE);
        return offset;
    }

    private int writeArray(MutableDirectBuffer buffer, int offset, byte[] array) {
        buffer.putBytes(offset, array);
        return offset + array.length;
    }

    public void close() {
        this.onClose.accept(this);
    }

    private static class Label {
        private final byte[] name;
        private final byte[] value;

        Label(String name, String value) {
            this.name = name.getBytes(StandardCharsets.UTF_8);
            this.value = value.getBytes(StandardCharsets.UTF_8);
        }

        public String toString() {
            return new String(this.name, StandardCharsets.UTF_8) + " = " + new String(this.value, StandardCharsets.UTF_8);
        }
    }
}

