/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.util.sched;

import io.zeebe.util.sched.ActorControl;
import java.util.function.Consumer;

public abstract class Actor {
    protected final ActorControl actor = new ActorControl(this);

    public String getName() {
        return this.getClass().getName();
    }

    protected void onActorStarting() {
    }

    protected void onActorStarted() {
    }

    protected void onActorClosing() {
    }

    protected void onActorClosed() {
    }

    protected void onActorCloseRequested() {
    }

    public static Actor wrap(final Consumer<ActorControl> r) {
        return new Actor(){

            @Override
            protected void onActorStarted() {
                r.accept(this.actor);
            }

            @Override
            public String getName() {
                return r.toString();
            }
        };
    }
}

