/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.util.sched;

import io.zeebe.util.sched.ActorCondition;
import io.zeebe.util.sched.ActorJob;
import io.zeebe.util.sched.ActorSubscription;
import io.zeebe.util.sched.ActorTask;
import org.agrona.UnsafeAccess;

public class ActorConditionImpl
implements ActorCondition,
ActorSubscription {
    private static final long TRIGGER_COUNT_OFFSET;
    private volatile long triggerCount = 0L;
    private long runCount = 0L;
    private final ActorJob job;
    private final String conditionName;
    private final ActorTask task;

    public ActorConditionImpl(String conditionName, ActorJob job) {
        this.conditionName = conditionName;
        this.job = job;
        this.task = job.getTask();
    }

    @Override
    public void signal() {
        UnsafeAccess.UNSAFE.getAndAddInt(this, TRIGGER_COUNT_OFFSET, 1);
        this.task.tryWakeup();
    }

    @Override
    public void onJobCompleted() {
        ++this.runCount;
    }

    @Override
    public boolean poll() {
        return this.triggerCount > this.runCount;
    }

    @Override
    public ActorJob getJob() {
        return this.job;
    }

    @Override
    public boolean isRecurring() {
        return true;
    }

    public String toString() {
        return "Condition " + this.conditionName;
    }

    @Override
    public void cancel() {
        this.task.onSubscriptionCancelled(this);
    }

    static {
        try {
            TRIGGER_COUNT_OFFSET = UnsafeAccess.UNSAFE.objectFieldOffset(ActorConditionImpl.class.getDeclaredField("triggerCount"));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

