/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.util.sched;

import io.zeebe.util.sched.Actor;
import io.zeebe.util.sched.ActorCondition;
import io.zeebe.util.sched.ActorConditionImpl;
import io.zeebe.util.sched.ActorFutureSubscription;
import io.zeebe.util.sched.ActorJob;
import io.zeebe.util.sched.ActorPriority;
import io.zeebe.util.sched.ActorTask;
import io.zeebe.util.sched.ActorThread;
import io.zeebe.util.sched.BlockingPollSubscription;
import io.zeebe.util.sched.RunnableAdapter;
import io.zeebe.util.sched.ScheduledTimer;
import io.zeebe.util.sched.TimerSubscription;
import io.zeebe.util.sched.channel.ChannelConsumerCondition;
import io.zeebe.util.sched.channel.ChannelSubscription;
import io.zeebe.util.sched.channel.ConsumableChannel;
import io.zeebe.util.sched.future.ActorFuture;
import io.zeebe.util.sched.future.AllCompletedFutureConsumer;
import io.zeebe.util.sched.future.FirstSuccessfullyCompletedFutureConsumer;
import io.zeebe.util.sched.future.FutureContinuationRunnable;
import java.time.Duration;
import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;

public class ActorControl {
    private final Actor actor;
    final ActorTask task;

    public ActorControl(Actor actor) {
        this.actor = actor;
        this.task = new ActorTask(actor);
    }

    public void setSchedulingHints(int hints) {
        this.ensureCalledFromWithinActor("resubmit(...)");
        this.task.setUpdatedSchedulingHints(hints);
    }

    public ChannelSubscription consume(ConsumableChannel channel, Runnable consumer) {
        this.ensureCalledFromWithinActor("consume(...)");
        ActorJob job = new ActorJob();
        job.setRunnable(consumer);
        job.setAutoCompleting(false);
        job.onJobAddedToTask(this.task);
        ChannelConsumerCondition subscription = new ChannelConsumerCondition(job, channel);
        job.setSubscription(subscription);
        channel.registerConsumer(subscription);
        return subscription;
    }

    public void pollBlocking(Runnable condition, Runnable action) {
        this.ensureCalledFromWithinActor("pollBlocking(...)");
        ActorJob job = new ActorJob();
        job.setRunnable(action);
        job.onJobAddedToTask(this.task);
        BlockingPollSubscription subscription = new BlockingPollSubscription(job, condition, this.task.getActorExecutor(), true);
        job.setSubscription(subscription);
        subscription.submit();
    }

    public ActorCondition onCondition(String conditionName, Runnable conditionAction) {
        this.ensureCalledFromWithinActor("onCondition(...)");
        ActorJob job = new ActorJob();
        job.setRunnable(conditionAction);
        job.onJobAddedToTask(this.task);
        ActorConditionImpl condition = new ActorConditionImpl(conditionName, job);
        job.setSubscription(condition);
        return condition;
    }

    public <T> ActorFuture<T> call(Callable<T> callable) {
        ActorThread runner = ActorThread.current();
        if (runner != null && runner.getCurrentTask() == this.task) {
            throw new UnsupportedOperationException("Incorrect usage of actor.call(...) cannot be called from current actor.");
        }
        ActorJob job = new ActorJob();
        ActorFuture future = job.setCallable(callable);
        job.onJobAddedToTask(this.task);
        job.setAutoCompleting(true);
        this.task.submit(job);
        return future;
    }

    public ActorFuture<Void> call(Runnable action) {
        Callable<Void> c = () -> {
            action.run();
            return null;
        };
        return this.call(c);
    }

    public void run(Runnable action) {
        this.scheduleRunnable(action, true);
    }

    public void runBlocking(Runnable runnable) {
        this.ensureCalledFromWithinActor("runBlocking(...)");
        ActorJob noop = new ActorJob();
        noop.onJobAddedToTask(this.task);
        noop.setAutoCompleting(true);
        noop.setRunnable(() -> {});
        BlockingPollSubscription subscription = new BlockingPollSubscription(noop, runnable, this.task.getActorExecutor(), false);
        noop.setSubscription(subscription);
        subscription.submit();
    }

    public void runBlocking(Runnable runnable, Consumer<Throwable> completionConsumer) {
        RunnableAdapter<Void> adapter = RunnableAdapter.wrapRunnable(runnable);
        this.ensureCalledFromWithinActor("runBlocking(...)");
        ActorJob noop = new ActorJob();
        noop.onJobAddedToTask(this.task);
        noop.setAutoCompleting(true);
        noop.setRunnable(adapter.wrapConsumer(completionConsumer));
        BlockingPollSubscription subscription = new BlockingPollSubscription(noop, adapter, this.task.getActorExecutor(), false);
        noop.setSubscription(subscription);
        subscription.submit();
    }

    public void runUntilDone(Runnable runnable) {
        this.ensureCalledFromWithinActor("runUntilDone(...)");
        this.scheduleRunnable(runnable, false);
    }

    public ScheduledTimer runDelayed(Duration delay, Runnable runnable) {
        this.ensureCalledFromWithinActor("runDelayed(...)");
        return this.scheduleTimer(delay, false, runnable);
    }

    public void submit(Runnable action) {
        ActorThread currentActorRunner = this.ensureCalledFromActorThread("run(...)");
        ActorTask currentTask = currentActorRunner.getCurrentTask();
        ActorJob job = currentTask == this.task ? currentActorRunner.newJob() : new ActorJob();
        job.setRunnable(action);
        job.setAutoCompleting(true);
        job.onJobAddedToTask(this.task);
        this.task.submit(job);
        if (currentTask == this.task) {
            this.yield();
        }
    }

    public ScheduledTimer runAtFixedRate(Duration delay, Runnable runnable) {
        this.ensureCalledFromWithinActor("runAtFixedRate(...)");
        return this.scheduleTimer(delay, true, runnable);
    }

    private TimerSubscription scheduleTimer(Duration delay, boolean isRecurring, Runnable runnable) {
        ActorJob job = new ActorJob();
        job.setRunnable(runnable);
        job.onJobAddedToTask(this.task);
        TimerSubscription timerSubscription = new TimerSubscription(job, delay.toNanos(), TimeUnit.NANOSECONDS, isRecurring);
        job.setSubscription(timerSubscription);
        timerSubscription.submit();
        return timerSubscription;
    }

    public <T> void runOnCompletion(ActorFuture<T> future, BiConsumer<T, Throwable> callback) {
        this.ensureCalledFromWithinActor("runOnCompletion(...)");
        ActorTask.ActorLifecyclePhase lifecyclePhase = this.task.getLifecyclePhase();
        if (lifecyclePhase != ActorTask.ActorLifecyclePhase.CLOSE_REQUESTED && lifecyclePhase != ActorTask.ActorLifecyclePhase.CLOSED) {
            this.submitContinuationJob(future, callback, job -> new ActorFutureSubscription(future, (ActorJob)job, lifecyclePhase.getValue()));
        }
    }

    public <T> void runOnCompletionBlockingCurrentPhase(ActorFuture<T> future, BiConsumer<T, Throwable> callback) {
        this.ensureCalledFromWithinActor("runOnCompletionBlockingCurrentPhase(...)");
        ActorTask.ActorLifecyclePhase lifecyclePhase = this.task.getLifecyclePhase();
        if (lifecyclePhase != ActorTask.ActorLifecyclePhase.CLOSED) {
            this.submitContinuationJob(future, callback, job -> new ActorFutureSubscription(future, (ActorJob)job, this.task.getLifecyclePhase().getValue() | ActorTask.ActorLifecyclePhase.CLOSE_REQUESTED.getValue()));
        }
    }

    private <T> void submitContinuationJob(ActorFuture<T> future, BiConsumer<T, Throwable> callback, Function<ActorJob, ActorFutureSubscription> futureSubscriptionSupplier) {
        ActorJob continuationJob = new ActorJob();
        continuationJob.setRunnable(new FutureContinuationRunnable<T>(future, callback));
        continuationJob.setAutoCompleting(true);
        continuationJob.onJobAddedToTask(this.task);
        ActorFutureSubscription subscription = futureSubscriptionSupplier.apply(continuationJob);
        continuationJob.setSubscription(subscription);
        future.block(this.task);
    }

    public <T> void runOnCompletion(Collection<ActorFuture<T>> futures, Consumer<Throwable> callback) {
        if (!futures.isEmpty()) {
            AllCompletedFutureConsumer futureConsumer = new AllCompletedFutureConsumer(futures.size(), callback);
            for (ActorFuture<T> future : futures) {
                this.runOnCompletion(future, futureConsumer);
            }
        } else {
            callback.accept(null);
        }
    }

    public <T> void runOnFirstCompletion(Collection<ActorFuture<T>> futures, BiConsumer<T, Throwable> callback) {
        this.runOnFirstCompletion(futures, callback, null);
    }

    public <T> void runOnFirstCompletion(Collection<ActorFuture<T>> futures, BiConsumer<T, Throwable> callback, Consumer<T> closer) {
        FirstSuccessfullyCompletedFutureConsumer<T> futureConsumer = new FirstSuccessfullyCompletedFutureConsumer<T>(futures.size(), callback, closer);
        for (ActorFuture<T> future : futures) {
            this.runOnCompletion(future, futureConsumer);
        }
    }

    public void yield() {
        ActorJob job = this.ensureCalledFromWithinActor("yield()");
        job.getTask().yield();
    }

    public ActorFuture<Void> close() {
        ActorJob closeJob = new ActorJob();
        closeJob.onJobAddedToTask(this.task);
        closeJob.setAutoCompleting(true);
        closeJob.setRunnable(this.task::requestClose);
        this.task.submit(closeJob);
        return this.task.closeFuture;
    }

    private void scheduleRunnable(Runnable runnable, boolean autocompleting) {
        ActorThread currentActorThread = ActorThread.current();
        if (currentActorThread != null && currentActorThread.getCurrentTask() == this.task) {
            ActorJob newJob = currentActorThread.newJob();
            newJob.setRunnable(runnable);
            newJob.setAutoCompleting(autocompleting);
            newJob.onJobAddedToTask(this.task);
            this.task.insertJob(newJob);
        } else {
            ActorJob job = new ActorJob();
            job.setRunnable(runnable);
            job.setAutoCompleting(autocompleting);
            job.onJobAddedToTask(this.task);
            this.task.submit(job);
        }
    }

    public void done() {
        ActorJob job = this.ensureCalledFromWithinActor("done()");
        job.markDone();
    }

    public boolean isClosing() {
        this.ensureCalledFromWithinActor("isClosing()");
        return this.task.isClosing();
    }

    public void setPriority(ActorPriority priority) {
        this.ensureCalledFromActorThread("setPriority()");
        this.task.setPriority(priority.getPriorityClass());
    }

    public ActorTask.ActorLifecyclePhase getLifecyclePhase() {
        this.ensureCalledFromWithinActor("getLifecyclePhase()");
        return this.task.getLifecyclePhase();
    }

    public boolean isCalledFromWithinActor(ActorJob job) {
        return job != null && job.getActor() == this.actor;
    }

    private ActorJob ensureCalledFromWithinActor(String methodName) {
        ActorJob currentJob = this.ensureCalledFromActorThread(methodName).getCurrentJob();
        if (!this.isCalledFromWithinActor(currentJob)) {
            throw new UnsupportedOperationException("Incorrect usage of actor." + methodName + ": must only be called from within the actor itself.");
        }
        return currentJob;
    }

    private ActorThread ensureCalledFromActorThread(String methodName) {
        ActorThread thread = ActorThread.current();
        if (thread == null) {
            throw new UnsupportedOperationException("Incorrect usage of actor. " + methodName + ": must be called from actor thread");
        }
        return thread;
    }
}

