/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.util.sched;

import io.zeebe.util.sched.ActorScheduler;
import io.zeebe.util.sched.ActorTask;
import io.zeebe.util.sched.ActorThreadGroup;
import io.zeebe.util.sched.MultiLevelWorkstealingGroup;
import io.zeebe.util.sched.PriorityScheduler;
import io.zeebe.util.sched.TaskScheduler;

public class CpuThreadGroup
extends ActorThreadGroup {
    public CpuThreadGroup(ActorScheduler.ActorSchedulerBuilder builder) {
        super(String.format("%s-%s", builder.getSchedulerName(), "zb-actors"), builder.getCpuBoundActorThreadCount(), builder.getPriorityQuotas().length, builder);
    }

    @Override
    protected TaskScheduler createTaskScheduler(MultiLevelWorkstealingGroup tasks, ActorScheduler.ActorSchedulerBuilder builder) {
        return new PriorityScheduler(tasks::getNextTask, builder.getPriorityQuotas());
    }

    @Override
    protected int getLevel(ActorTask actorTask) {
        return actorTask.getPriority();
    }
}

