/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.util.sched.clock;

import io.zeebe.util.sched.clock.ActorClock;
import java.time.Duration;
import java.time.Instant;

public class ControlledActorClock
implements ActorClock {
    private volatile long currentTime;
    private volatile long currentOffset;

    public ControlledActorClock() {
        this.reset();
    }

    public void setCurrentTime(long currentTime) {
        this.currentTime = currentTime;
    }

    public void setCurrentTime(Instant currentTime) {
        this.currentTime = currentTime.toEpochMilli();
    }

    public void pinCurrentTime() {
        this.setCurrentTime(this.getCurrentTime());
    }

    public void addTime(Duration durationToAdd) {
        if (this.usesPointInTime()) {
            this.currentTime += durationToAdd.toMillis();
        } else {
            this.currentOffset += durationToAdd.toMillis();
        }
    }

    public void reset() {
        this.currentTime = -1L;
        this.currentOffset = 0L;
    }

    @Override
    public long getTimeMillis() {
        if (this.usesPointInTime()) {
            return this.currentTime;
        }
        long now = System.currentTimeMillis();
        if (this.usesOffset()) {
            now += this.currentOffset;
        }
        return now;
    }

    public Instant getCurrentTime() {
        return Instant.ofEpochMilli(this.getTimeMillis());
    }

    protected boolean usesPointInTime() {
        return this.currentTime > 0L;
    }

    protected boolean usesOffset() {
        return this.currentOffset > 0L;
    }

    @Override
    public boolean update() {
        return true;
    }

    @Override
    public long getNanosSinceLastMillisecond() {
        return 0L;
    }

    @Override
    public long getNanoTime() {
        return 0L;
    }

    public long getCurrentTimeInMillis() {
        return this.getTimeMillis();
    }
}

