/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.util.sched.future;

import java.util.function.BiConsumer;
import java.util.function.Consumer;

public class FirstSuccessfullyCompletedFutureConsumer<T>
implements BiConsumer<T, Throwable> {
    private final BiConsumer<T, Throwable> callback;
    private final Consumer<T> closer;
    private boolean isCompleted = false;
    private int pendingFutures;

    public FirstSuccessfullyCompletedFutureConsumer(int pendingFutures, BiConsumer<T, Throwable> callback, Consumer<T> closer) {
        this.pendingFutures = pendingFutures;
        this.callback = callback;
        this.closer = closer;
    }

    @Override
    public void accept(T result, Throwable failure) {
        --this.pendingFutures;
        if (failure == null) {
            if (!this.isCompleted) {
                this.isCompleted = true;
                this.callback.accept(result, null);
            } else if (this.closer != null) {
                this.closer.accept(result);
            }
        } else if (this.pendingFutures == 0) {
            this.callback.accept(null, failure);
        }
    }
}

