/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.util.sched.future;

import io.zeebe.util.Loggers;
import io.zeebe.util.sched.future.ActorFuture;
import java.util.function.BiConsumer;

public class FutureContinuationRunnable<T>
implements Runnable {
    private ActorFuture<T> future;
    private BiConsumer<T, Throwable> consumer;

    public FutureContinuationRunnable(ActorFuture<T> future, BiConsumer<T, Throwable> consumer) {
        this.future = future;
        this.consumer = consumer;
    }

    @Override
    public void run() {
        if (!this.future.isCompletedExceptionally()) {
            try {
                Object res = this.future.get();
                this.consumer.accept(res, null);
            }
            catch (Throwable e) {
                Loggers.ACTOR_LOGGER.debug("Continuing on future completion failed", e);
            }
        } else {
            this.consumer.accept(null, this.future.getException());
        }
    }
}

