/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.util.sched.metrics;

import io.zeebe.util.metrics.Metric;
import io.zeebe.util.metrics.MetricsManager;

public class TaskMetrics
implements AutoCloseable {
    private final Metric executionCount;
    private final Metric totalExecutionTime;
    private final Metric maxExecutionTime;

    public TaskMetrics(String taskName, MetricsManager metricsManager) {
        this.executionCount = metricsManager.newMetric("scheduler_task_execution_count").type("counter").label("task", taskName).create();
        this.totalExecutionTime = metricsManager.newMetric("scheduler_task_execution_time_total").type("counter").label("task", taskName).create();
        this.maxExecutionTime = metricsManager.newMetric("scheduler_task_execution_time_max").type("gauge").label("task", taskName).create();
    }

    public void reportExecutionTime(long executionTimeNs) {
        assert (executionTimeNs >= 0L);
        long max = this.maxExecutionTime.getWeak();
        if (executionTimeNs > max) {
            this.maxExecutionTime.setOrdered(executionTimeNs);
        }
        this.totalExecutionTime.getAndAddOrdered(executionTimeNs);
        this.executionCount.incrementOrdered();
    }

    @Override
    public void close() {
        this.executionCount.close();
        this.totalExecutionTime.close();
        this.maxExecutionTime.close();
    }
}

