/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.util.sched.testing;

import io.zeebe.util.LangUtil;
import io.zeebe.util.sched.ActorThread;
import io.zeebe.util.sched.ActorThreadGroup;
import io.zeebe.util.sched.ActorTimerQueue;
import io.zeebe.util.sched.TaskScheduler;
import io.zeebe.util.sched.clock.ActorClock;
import io.zeebe.util.sched.metrics.ActorThreadMetrics;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.CyclicBarrier;

public class ControlledActorThread
extends ActorThread {
    private CyclicBarrier barrier = new CyclicBarrier(2);

    public ControlledActorThread(String name, int id, ActorThreadGroup threadGroup, TaskScheduler taskScheduler, ActorClock clock, ActorThreadMetrics metrics, ActorTimerQueue timerQueue) {
        super(name, id, threadGroup, taskScheduler, clock, metrics, timerQueue);
        this.idleStrategy = new ControlledIdleStartegy();
    }

    public void workUntilDone() {
        try {
            this.barrier.await();
            while (this.barrier.getNumberWaiting() < 1) {
                Thread.yield();
            }
        }
        catch (InterruptedException | BrokenBarrierException e) {
            LangUtil.rethrowUnchecked(e);
        }
    }

    class ControlledIdleStartegy
    extends ActorThread.ActorTaskRunnerIdleStrategy {
        ControlledIdleStartegy() {
        }

        @Override
        protected void onIdle() {
            super.onIdle();
            try {
                ControlledActorThread.this.barrier.await();
            }
            catch (InterruptedException | BrokenBarrierException e) {
                LangUtil.rethrowUnchecked(e);
            }
        }
    }
}

