/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.dispatcher;

import io.zeebe.dispatcher.AtomicPosition;
import io.zeebe.dispatcher.impl.PositionUtil;
import io.zeebe.dispatcher.impl.log.DataFrameDescriptor;
import io.zeebe.util.metrics.Metric;
import io.zeebe.util.sched.ActorCondition;
import java.nio.ByteBuffer;
import java.util.Iterator;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

public class BlockPeek
implements Iterable<DirectBuffer> {
    protected ByteBuffer byteBuffer;
    protected UnsafeBuffer bufferView = new UnsafeBuffer(0L, 0);
    protected AtomicPosition subscriberPosition;
    protected int streamId;
    protected int bufferOffset;
    protected int blockLength;
    protected int newPartitionId;
    protected int newPartitionOffset;
    protected DataFrameIterator iterator = new DataFrameIterator();
    private ActorCondition dataConsumed;
    private int fragmentCount;
    private Metric fragmentsConsumedMetric;

    public void setBlock(ByteBuffer byteBuffer, AtomicPosition position, ActorCondition dataConsumed, int streamId, int bufferOffset, int blockLength, int newPartitionId, int newPartitionOffset, int fragmentCount, Metric fragmentsConsumedMetric) {
        this.byteBuffer = byteBuffer;
        this.subscriberPosition = position;
        this.dataConsumed = dataConsumed;
        this.streamId = streamId;
        this.bufferOffset = bufferOffset;
        this.blockLength = blockLength;
        this.newPartitionId = newPartitionId;
        this.newPartitionOffset = newPartitionOffset;
        this.fragmentCount = fragmentCount;
        this.fragmentsConsumedMetric = fragmentsConsumedMetric;
        byteBuffer.limit(bufferOffset + blockLength);
        byteBuffer.position(bufferOffset);
        this.bufferView.wrap(byteBuffer, bufferOffset, blockLength);
    }

    public ByteBuffer getRawBuffer() {
        return this.byteBuffer;
    }

    public MutableDirectBuffer getBuffer() {
        return this.bufferView;
    }

    public void markFailed() {
        int frameLength;
        for (int fragmentOffset = 0; fragmentOffset < this.blockLength; fragmentOffset += frameLength) {
            int framedFragmentLength = this.bufferView.getInt(DataFrameDescriptor.lengthOffset(fragmentOffset));
            if (framedFragmentLength < 0) {
                framedFragmentLength = -framedFragmentLength;
            }
            frameLength = DataFrameDescriptor.alignedLength(framedFragmentLength);
            int flagsOffset = DataFrameDescriptor.flagsOffset(fragmentOffset);
            byte flags = this.bufferView.getByte(flagsOffset);
            this.bufferView.putByte(flagsOffset, DataFrameDescriptor.enableFlagFailed(flags));
        }
        this.updatePosition();
    }

    public void markCompleted() {
        this.updatePosition();
    }

    public long getNextPosition() {
        long newPosition = PositionUtil.position(this.newPartitionId, this.newPartitionOffset);
        if (this.subscriberPosition.get() < newPosition) {
            return newPosition;
        }
        return this.subscriberPosition.get();
    }

    protected void updatePosition() {
        this.fragmentsConsumedMetric.getAndAddOrdered((long)this.fragmentCount);
        this.subscriberPosition.proposeMaxOrdered(PositionUtil.position(this.newPartitionId, this.newPartitionOffset));
        this.dataConsumed.signal();
    }

    public int getStreamId() {
        return this.streamId;
    }

    public int getBufferOffset() {
        return this.bufferOffset;
    }

    public int getBlockLength() {
        return this.blockLength;
    }

    public long getBlockPosition() {
        return PositionUtil.position(this.newPartitionId, this.newPartitionOffset);
    }

    @Override
    public Iterator<DirectBuffer> iterator() {
        this.iterator.reset();
        return this.iterator;
    }

    protected class DataFrameIterator
    implements Iterator<DirectBuffer> {
        protected int iterationOffset;
        protected UnsafeBuffer buffer = new UnsafeBuffer(0L, 0);

        protected DataFrameIterator() {
        }

        public void reset() {
            this.iterationOffset = 0;
        }

        @Override
        public boolean hasNext() {
            return this.iterationOffset < BlockPeek.this.blockLength;
        }

        @Override
        public DirectBuffer next() {
            int framedFragmentLength = BlockPeek.this.bufferView.getInt(DataFrameDescriptor.lengthOffset(this.iterationOffset));
            int fragmentLength = DataFrameDescriptor.messageLength(framedFragmentLength);
            int messageOffset = DataFrameDescriptor.messageOffset(this.iterationOffset);
            this.buffer.wrap((DirectBuffer)BlockPeek.this.bufferView, messageOffset, fragmentLength);
            this.iterationOffset += DataFrameDescriptor.alignedLength(framedFragmentLength);
            return this.buffer;
        }
    }
}

