/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.dispatcher.impl.log;

import io.zeebe.dispatcher.ClaimedFragment;
import io.zeebe.dispatcher.ClaimedFragmentBatch;
import io.zeebe.dispatcher.impl.log.DataFrameDescriptor;
import io.zeebe.dispatcher.impl.log.LogBufferPartition;
import org.agrona.BitUtil;
import org.agrona.DirectBuffer;
import org.agrona.UnsafeAccess;
import org.agrona.concurrent.UnsafeBuffer;

public class LogBufferAppender {
    public static final int RESULT_PADDING_AT_END_OF_PARTITION = -2;
    public static final int RESULT_END_OF_PARTITION = -1;

    public int appendFrame(LogBufferPartition partition, int activePartitionId, DirectBuffer msg, int start, int length, int streamId) {
        int partitionSize = partition.getPartitionSize();
        int framedLength = DataFrameDescriptor.framedLength(length);
        int alignedFrameLength = DataFrameDescriptor.alignedLength(framedLength);
        int frameOffset = partition.getAndAddTail(alignedFrameLength);
        int newTail = frameOffset + alignedFrameLength;
        if (newTail <= partitionSize - DataFrameDescriptor.HEADER_LENGTH) {
            UnsafeBuffer buffer = partition.getDataBuffer();
            buffer.putIntOrdered(DataFrameDescriptor.lengthOffset(frameOffset), -framedLength);
            UnsafeAccess.UNSAFE.storeFence();
            buffer.putShort(DataFrameDescriptor.typeOffset(frameOffset), (short)0);
            buffer.putInt(DataFrameDescriptor.streamIdOffset(frameOffset), streamId);
            buffer.putBytes(DataFrameDescriptor.messageOffset(frameOffset), msg, start, length);
            buffer.putIntOrdered(DataFrameDescriptor.lengthOffset(frameOffset), framedLength);
        } else {
            newTail = this.onEndOfPartition(partition, frameOffset);
        }
        return newTail;
    }

    public int claim(LogBufferPartition partition, int activePartitionId, ClaimedFragment claim, int length, int streamId, Runnable onComplete) {
        int partitionSize = partition.getPartitionSize();
        int framedMessageLength = DataFrameDescriptor.framedLength(length);
        int alignedFrameLength = DataFrameDescriptor.alignedLength(framedMessageLength);
        int frameOffset = partition.getAndAddTail(alignedFrameLength);
        int newTail = frameOffset + alignedFrameLength;
        if (newTail <= partitionSize - DataFrameDescriptor.HEADER_LENGTH) {
            UnsafeBuffer buffer = partition.getDataBuffer();
            buffer.putIntOrdered(DataFrameDescriptor.lengthOffset(frameOffset), -framedMessageLength);
            UnsafeAccess.UNSAFE.storeFence();
            buffer.putShort(DataFrameDescriptor.typeOffset(frameOffset), (short)0);
            buffer.putInt(DataFrameDescriptor.streamIdOffset(frameOffset), streamId);
            claim.wrap(buffer, frameOffset, framedMessageLength, onComplete);
        } else {
            newTail = this.onEndOfPartition(partition, frameOffset);
        }
        return newTail;
    }

    public int claim(LogBufferPartition partition, int activePartitionId, ClaimedFragmentBatch batch, int fragmentCount, int batchLength, Runnable onComplete) {
        int partitionSize = partition.getPartitionSize();
        int framedMessageLength = batchLength + fragmentCount * (DataFrameDescriptor.HEADER_LENGTH + 8) + 8;
        int alignedFrameLength = BitUtil.align((int)framedMessageLength, (int)8);
        int frameOffset = partition.getAndAddTail(alignedFrameLength);
        int newTail = frameOffset + alignedFrameLength;
        if (newTail <= partitionSize - DataFrameDescriptor.HEADER_LENGTH) {
            UnsafeBuffer buffer = partition.getDataBuffer();
            batch.wrap(buffer, activePartitionId, frameOffset, alignedFrameLength, onComplete);
        } else {
            newTail = this.onEndOfPartition(partition, frameOffset);
        }
        return newTail;
    }

    protected int onEndOfPartition(LogBufferPartition partition, int partitionOffset) {
        int newTail = -1;
        int padLength = partition.getPartitionSize() - partitionOffset;
        if (padLength >= DataFrameDescriptor.HEADER_LENGTH) {
            UnsafeBuffer buffer = partition.getDataBuffer();
            buffer.putIntOrdered(DataFrameDescriptor.lengthOffset(partitionOffset), -padLength);
            UnsafeAccess.UNSAFE.storeFence();
            buffer.putShort(DataFrameDescriptor.typeOffset(partitionOffset), (short)1);
            buffer.putIntOrdered(DataFrameDescriptor.lengthOffset(partitionOffset), padLength);
            newTail = -2;
        }
        return newTail;
    }
}

