/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.protocol.record;

import io.zeebe.protocol.record.MessageHeaderEncoder;
import io.zeebe.protocol.record.MetaAttribute;
import io.zeebe.protocol.record.RecordMetadataDecoder;
import io.zeebe.protocol.record.RecordType;
import io.zeebe.protocol.record.RejectionType;
import io.zeebe.protocol.record.ValueType;
import java.io.UnsupportedEncodingException;
import java.nio.ByteOrder;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.collections.ArrayUtil;
import org.agrona.sbe.MessageEncoderFlyweight;

public class RecordMetadataEncoder
implements MessageEncoderFlyweight {
    public static final int BLOCK_LENGTH = 20;
    public static final int TEMPLATE_ID = 200;
    public static final int SCHEMA_ID = 0;
    public static final int SCHEMA_VERSION = 1;
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private final RecordMetadataEncoder parentMessage = this;
    private MutableDirectBuffer buffer;
    protected int offset;
    protected int limit;

    public int sbeBlockLength() {
        return 20;
    }

    public int sbeTemplateId() {
        return 200;
    }

    public int sbeSchemaId() {
        return 0;
    }

    public int sbeSchemaVersion() {
        return 1;
    }

    public String sbeSemanticType() {
        return "";
    }

    public MutableDirectBuffer buffer() {
        return this.buffer;
    }

    public int offset() {
        return this.offset;
    }

    public RecordMetadataEncoder wrap(MutableDirectBuffer buffer, int offset) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.offset = offset;
        this.limit(offset + 20);
        return this;
    }

    public RecordMetadataEncoder wrapAndApplyHeader(MutableDirectBuffer buffer, int offset, MessageHeaderEncoder headerEncoder) {
        headerEncoder.wrap(buffer, offset).blockLength(20).templateId(200).schemaId(0).version(1);
        return this.wrap(buffer, offset + 8);
    }

    public int encodedLength() {
        return this.limit - this.offset;
    }

    public int limit() {
        return this.limit;
    }

    public void limit(int limit) {
        this.limit = limit;
    }

    public static int partitionIdId() {
        return 1;
    }

    public static int partitionIdSinceVersion() {
        return 0;
    }

    public static int partitionIdEncodingOffset() {
        return 0;
    }

    public static int partitionIdEncodingLength() {
        return 2;
    }

    public static String partitionIdMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "";
            }
            case TIME_UNIT: {
                return "";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
            case PRESENCE: {
                return "required";
            }
        }
        return "";
    }

    public static int partitionIdNullValue() {
        return 65535;
    }

    public static int partitionIdMinValue() {
        return 0;
    }

    public static int partitionIdMaxValue() {
        return 65534;
    }

    public RecordMetadataEncoder partitionId(int value) {
        this.buffer.putShort(this.offset + 0, (short)value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int recordTypeId() {
        return 2;
    }

    public static int recordTypeSinceVersion() {
        return 0;
    }

    public static int recordTypeEncodingOffset() {
        return 2;
    }

    public static int recordTypeEncodingLength() {
        return 1;
    }

    public static String recordTypeMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "";
            }
            case TIME_UNIT: {
                return "";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
            case PRESENCE: {
                return "required";
            }
        }
        return "";
    }

    public RecordMetadataEncoder recordType(RecordType value) {
        this.buffer.putByte(this.offset + 2, (byte)value.value());
        return this;
    }

    public static int requestStreamIdId() {
        return 3;
    }

    public static int requestStreamIdSinceVersion() {
        return 0;
    }

    public static int requestStreamIdEncodingOffset() {
        return 3;
    }

    public static int requestStreamIdEncodingLength() {
        return 4;
    }

    public static String requestStreamIdMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "";
            }
            case TIME_UNIT: {
                return "";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
            case PRESENCE: {
                return "required";
            }
        }
        return "";
    }

    public static int requestStreamIdNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int requestStreamIdMinValue() {
        return -2147483647;
    }

    public static int requestStreamIdMaxValue() {
        return Integer.MAX_VALUE;
    }

    public RecordMetadataEncoder requestStreamId(int value) {
        this.buffer.putInt(this.offset + 3, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int requestIdId() {
        return 4;
    }

    public static int requestIdSinceVersion() {
        return 0;
    }

    public static int requestIdEncodingOffset() {
        return 7;
    }

    public static int requestIdEncodingLength() {
        return 8;
    }

    public static String requestIdMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "";
            }
            case TIME_UNIT: {
                return "";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
            case PRESENCE: {
                return "required";
            }
        }
        return "";
    }

    public static long requestIdNullValue() {
        return -1L;
    }

    public static long requestIdMinValue() {
        return 0L;
    }

    public static long requestIdMaxValue() {
        return -2L;
    }

    public RecordMetadataEncoder requestId(long value) {
        this.buffer.putLong(this.offset + 7, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int protocolVersionId() {
        return 5;
    }

    public static int protocolVersionSinceVersion() {
        return 0;
    }

    public static int protocolVersionEncodingOffset() {
        return 15;
    }

    public static int protocolVersionEncodingLength() {
        return 2;
    }

    public static String protocolVersionMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "";
            }
            case TIME_UNIT: {
                return "";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
            case PRESENCE: {
                return "required";
            }
        }
        return "";
    }

    public static int protocolVersionNullValue() {
        return 65535;
    }

    public static int protocolVersionMinValue() {
        return 0;
    }

    public static int protocolVersionMaxValue() {
        return 65534;
    }

    public RecordMetadataEncoder protocolVersion(int value) {
        this.buffer.putShort(this.offset + 15, (short)value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int valueTypeId() {
        return 6;
    }

    public static int valueTypeSinceVersion() {
        return 0;
    }

    public static int valueTypeEncodingOffset() {
        return 17;
    }

    public static int valueTypeEncodingLength() {
        return 1;
    }

    public static String valueTypeMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "";
            }
            case TIME_UNIT: {
                return "";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
            case PRESENCE: {
                return "required";
            }
        }
        return "";
    }

    public RecordMetadataEncoder valueType(ValueType value) {
        this.buffer.putByte(this.offset + 17, (byte)value.value());
        return this;
    }

    public static int intentId() {
        return 7;
    }

    public static int intentSinceVersion() {
        return 0;
    }

    public static int intentEncodingOffset() {
        return 18;
    }

    public static int intentEncodingLength() {
        return 1;
    }

    public static String intentMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "";
            }
            case TIME_UNIT: {
                return "";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
            case PRESENCE: {
                return "required";
            }
        }
        return "";
    }

    public static short intentNullValue() {
        return 255;
    }

    public static short intentMinValue() {
        return 0;
    }

    public static short intentMaxValue() {
        return 254;
    }

    public RecordMetadataEncoder intent(short value) {
        this.buffer.putByte(this.offset + 18, (byte)value);
        return this;
    }

    public static int rejectionTypeId() {
        return 8;
    }

    public static int rejectionTypeSinceVersion() {
        return 0;
    }

    public static int rejectionTypeEncodingOffset() {
        return 19;
    }

    public static int rejectionTypeEncodingLength() {
        return 1;
    }

    public static String rejectionTypeMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "";
            }
            case TIME_UNIT: {
                return "";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
            case PRESENCE: {
                return "required";
            }
        }
        return "";
    }

    public RecordMetadataEncoder rejectionType(RejectionType value) {
        this.buffer.putByte(this.offset + 19, (byte)value.value());
        return this;
    }

    public static int rejectionReasonId() {
        return 9;
    }

    public static String rejectionReasonCharacterEncoding() {
        return "UTF-8";
    }

    public static String rejectionReasonMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "unix";
            }
            case TIME_UNIT: {
                return "nanosecond";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
            case PRESENCE: {
                return "required";
            }
        }
        return "";
    }

    public static int rejectionReasonHeaderLength() {
        return 2;
    }

    public RecordMetadataEncoder putRejectionReason(DirectBuffer src, int srcOffset, int length) {
        if (length > 65534) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 2 + length);
        this.buffer.putShort(limit, (short)length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 2, src, srcOffset, length);
        return this;
    }

    public RecordMetadataEncoder putRejectionReason(byte[] src, int srcOffset, int length) {
        if (length > 65534) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 2 + length);
        this.buffer.putShort(limit, (short)length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 2, src, srcOffset, length);
        return this;
    }

    public RecordMetadataEncoder rejectionReason(String value) {
        byte[] bytes;
        try {
            bytes = null == value || value.isEmpty() ? ArrayUtil.EMPTY_BYTE_ARRAY : value.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
        int length = bytes.length;
        if (length > 65534) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 2 + length);
        this.buffer.putShort(limit, (short)length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 2, bytes, 0, length);
        return this;
    }

    public String toString() {
        return this.appendTo(new StringBuilder(100)).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        RecordMetadataDecoder writer = new RecordMetadataDecoder();
        writer.wrap((DirectBuffer)this.buffer, this.offset, 20, 1);
        return writer.appendTo(builder);
    }
}

