/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.protocol.record.intent;

import io.zeebe.protocol.record.ValueType;
import io.zeebe.protocol.record.intent.DeploymentIntent;
import io.zeebe.protocol.record.intent.ErrorIntent;
import io.zeebe.protocol.record.intent.ExporterIntent;
import io.zeebe.protocol.record.intent.IncidentIntent;
import io.zeebe.protocol.record.intent.JobBatchIntent;
import io.zeebe.protocol.record.intent.JobIntent;
import io.zeebe.protocol.record.intent.MessageIntent;
import io.zeebe.protocol.record.intent.MessageStartEventSubscriptionIntent;
import io.zeebe.protocol.record.intent.MessageSubscriptionIntent;
import io.zeebe.protocol.record.intent.TimerIntent;
import io.zeebe.protocol.record.intent.VariableDocumentIntent;
import io.zeebe.protocol.record.intent.VariableIntent;
import io.zeebe.protocol.record.intent.WorkflowInstanceCreationIntent;
import io.zeebe.protocol.record.intent.WorkflowInstanceIntent;
import io.zeebe.protocol.record.intent.WorkflowInstanceSubscriptionIntent;
import java.util.Arrays;
import java.util.Collection;

public interface Intent {
    public static final Collection<Class<? extends Intent>> INTENT_CLASSES = Arrays.asList(DeploymentIntent.class, IncidentIntent.class, JobIntent.class, WorkflowInstanceIntent.class, MessageIntent.class, MessageSubscriptionIntent.class, WorkflowInstanceSubscriptionIntent.class, ExporterIntent.class, JobBatchIntent.class, TimerIntent.class, VariableIntent.class, VariableDocumentIntent.class, WorkflowInstanceCreationIntent.class, ErrorIntent.class);
    public static final Intent UNKNOWN = new Intent(){

        @Override
        public short value() {
            return 255;
        }

        @Override
        public String name() {
            return "UNKNOWN";
        }
    };
    public static final short NULL_VAL = 255;

    public short value();

    public String name();

    public static Intent fromProtocolValue(ValueType valueType, short intent) {
        switch (valueType) {
            case DEPLOYMENT: {
                return DeploymentIntent.from(intent);
            }
            case INCIDENT: {
                return IncidentIntent.from(intent);
            }
            case NOOP: {
                return UNKNOWN;
            }
            case JOB: {
                return JobIntent.from(intent);
            }
            case WORKFLOW_INSTANCE: {
                return WorkflowInstanceIntent.from(intent);
            }
            case MESSAGE: {
                return MessageIntent.from(intent);
            }
            case MESSAGE_SUBSCRIPTION: {
                return MessageSubscriptionIntent.from(intent);
            }
            case MESSAGE_START_EVENT_SUBSCRIPTION: {
                return MessageStartEventSubscriptionIntent.from(intent);
            }
            case WORKFLOW_INSTANCE_SUBSCRIPTION: {
                return WorkflowInstanceSubscriptionIntent.from(intent);
            }
            case EXPORTER: {
                return ExporterIntent.from(intent);
            }
            case JOB_BATCH: {
                return JobBatchIntent.from(intent);
            }
            case TIMER: {
                return TimerIntent.from(intent);
            }
            case VARIABLE: {
                return VariableIntent.from(intent);
            }
            case VARIABLE_DOCUMENT: {
                return VariableDocumentIntent.from(intent);
            }
            case WORKFLOW_INSTANCE_CREATION: {
                return WorkflowInstanceCreationIntent.from(intent);
            }
            case ERROR: {
                return ErrorIntent.from(intent);
            }
            case NULL_VAL: 
            case SBE_UNKNOWN: {
                return UNKNOWN;
            }
        }
        throw new RuntimeException(String.format("Expected to map value type %s to intent type, but did not recognize the value type", valueType.name()));
    }

    public static Intent fromProtocolValue(ValueType valueType, String intent) {
        switch (valueType) {
            case DEPLOYMENT: {
                return DeploymentIntent.valueOf(intent);
            }
            case INCIDENT: {
                return IncidentIntent.valueOf(intent);
            }
            case NOOP: {
                return UNKNOWN;
            }
            case JOB: {
                return JobIntent.valueOf(intent);
            }
            case WORKFLOW_INSTANCE: {
                return WorkflowInstanceIntent.valueOf(intent);
            }
            case MESSAGE: {
                return WorkflowInstanceIntent.valueOf(intent);
            }
            case MESSAGE_SUBSCRIPTION: {
                return MessageSubscriptionIntent.valueOf(intent);
            }
            case MESSAGE_START_EVENT_SUBSCRIPTION: {
                return MessageStartEventSubscriptionIntent.valueOf(intent);
            }
            case WORKFLOW_INSTANCE_SUBSCRIPTION: {
                return WorkflowInstanceSubscriptionIntent.valueOf(intent);
            }
            case EXPORTER: {
                return ExporterIntent.valueOf(intent);
            }
            case JOB_BATCH: {
                return JobBatchIntent.valueOf(intent);
            }
            case TIMER: {
                return TimerIntent.valueOf(intent);
            }
            case VARIABLE: {
                return VariableIntent.valueOf(intent);
            }
            case VARIABLE_DOCUMENT: {
                return VariableDocumentIntent.valueOf(intent);
            }
            case WORKFLOW_INSTANCE_CREATION: {
                return WorkflowInstanceCreationIntent.valueOf(intent);
            }
            case ERROR: {
                return ErrorIntent.valueOf(intent);
            }
            case NULL_VAL: 
            case SBE_UNKNOWN: {
                return UNKNOWN;
            }
        }
        throw new RuntimeException(String.format("Expected to map value type %s to intent type, but did not recognize the value type", valueType.name()));
    }

    public static int maxCardinality() {
        return INTENT_CLASSES.stream().mapToInt(clazz -> ((Intent[])clazz.getEnumConstants()).length).max().getAsInt();
    }
}

