/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.protocol.record.intent;

import io.zeebe.protocol.record.intent.Intent;
import io.zeebe.protocol.record.intent.WorkflowInstanceRelatedIntent;

public enum JobIntent implements WorkflowInstanceRelatedIntent
{
    CREATE(0),
    CREATED(1),
    ACTIVATED(2),
    COMPLETE(3, false),
    COMPLETED(4),
    TIME_OUT(5),
    TIMED_OUT(6),
    FAIL(7, false),
    FAILED(8),
    UPDATE_RETRIES(9, false),
    RETRIES_UPDATED(10),
    CANCEL(11),
    CANCELED(12);

    private final short value;
    private final boolean shouldBlacklist;

    private JobIntent(short value) {
        this(value, true);
    }

    private JobIntent(short value, boolean shouldBlacklist) {
        this.value = value;
        this.shouldBlacklist = shouldBlacklist;
    }

    public short getIntent() {
        return this.value;
    }

    public static Intent from(short value) {
        switch (value) {
            case 0: {
                return CREATE;
            }
            case 1: {
                return CREATED;
            }
            case 2: {
                return ACTIVATED;
            }
            case 3: {
                return COMPLETE;
            }
            case 4: {
                return COMPLETED;
            }
            case 5: {
                return TIME_OUT;
            }
            case 6: {
                return TIMED_OUT;
            }
            case 7: {
                return FAIL;
            }
            case 8: {
                return FAILED;
            }
            case 9: {
                return UPDATE_RETRIES;
            }
            case 10: {
                return RETRIES_UPDATED;
            }
            case 11: {
                return CANCEL;
            }
            case 12: {
                return CANCELED;
            }
        }
        return UNKNOWN;
    }

    @Override
    public short value() {
        return this.value;
    }

    @Override
    public boolean shouldBlacklistInstanceOnError() {
        return this.shouldBlacklist;
    }
}

