/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.protocol.record.intent;

import io.zeebe.protocol.record.intent.Intent;
import io.zeebe.protocol.record.intent.WorkflowInstanceRelatedIntent;

public enum MessageSubscriptionIntent implements WorkflowInstanceRelatedIntent
{
    OPEN(0),
    OPENED(1),
    CORRELATE(2),
    CORRELATED(3),
    REJECT(4),
    REJECTED(5),
    CLOSE(6),
    CLOSED(7);

    private final short value;
    private final boolean shouldBlacklist;

    private MessageSubscriptionIntent(short value) {
        this(value, true);
    }

    private MessageSubscriptionIntent(short value, boolean shouldBlacklist) {
        this.value = value;
        this.shouldBlacklist = shouldBlacklist;
    }

    @Override
    public short value() {
        return this.value;
    }

    public static Intent from(short value) {
        switch (value) {
            case 0: {
                return OPEN;
            }
            case 1: {
                return OPENED;
            }
            case 2: {
                return CORRELATE;
            }
            case 3: {
                return CORRELATED;
            }
            case 4: {
                return REJECT;
            }
            case 5: {
                return REJECTED;
            }
            case 6: {
                return CLOSE;
            }
            case 7: {
                return CLOSED;
            }
        }
        return Intent.UNKNOWN;
    }

    @Override
    public boolean shouldBlacklistInstanceOnError() {
        return this.shouldBlacklist;
    }
}

