/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.protocol.record.value;

public enum BpmnElementType {
    UNSPECIFIED,
    PROCESS,
    SUB_PROCESS,
    START_EVENT,
    INTERMEDIATE_CATCH_EVENT,
    BOUNDARY_EVENT,
    END_EVENT,
    SERVICE_TASK,
    RECEIVE_TASK,
    EXCLUSIVE_GATEWAY,
    PARALLEL_GATEWAY,
    EVENT_BASED_GATEWAY,
    SEQUENCE_FLOW;


    public static BpmnElementType bpmnElementTypeFor(String elementTypeName) {
        switch (elementTypeName) {
            case "process": {
                return PROCESS;
            }
            case "subProcess": {
                return SUB_PROCESS;
            }
            case "startEvent": {
                return START_EVENT;
            }
            case "intermediateCatchEvent": {
                return INTERMEDIATE_CATCH_EVENT;
            }
            case "boundaryEvent": {
                return BOUNDARY_EVENT;
            }
            case "endEvent": {
                return END_EVENT;
            }
            case "serviceTask": {
                return SERVICE_TASK;
            }
            case "receiveTask": {
                return RECEIVE_TASK;
            }
            case "exclusiveGateway": {
                return EXCLUSIVE_GATEWAY;
            }
            case "eventBasedGateway": {
                return EVENT_BASED_GATEWAY;
            }
            case "parallelGateway": {
                return PARALLEL_GATEWAY;
            }
            case "sequenceFlow": {
                return SEQUENCE_FLOW;
            }
        }
        throw new RuntimeException("Unsupported BPMN element of type " + elementTypeName);
    }
}

