/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.transport;

import io.zeebe.util.StringUtil;
import java.net.InetSocketAddress;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

public class SocketAddress
implements Comparable<SocketAddress> {
    public static final int MAX_HOST_LENGTH = 128;
    protected final byte[] byteArray = new byte[128];
    protected final UnsafeBuffer hostBuffer = new UnsafeBuffer(this.byteArray, 0, 0);
    protected int port;

    public SocketAddress() {
    }

    public SocketAddress(String host, int port) {
        this();
        this.host(host);
        this.port(port);
    }

    public SocketAddress(InetSocketAddress address) {
        this(address.getHostName(), address.getPort());
    }

    public SocketAddress(SocketAddress other) {
        this();
        this.host((DirectBuffer)other.hostBuffer, 0, other.hostLength());
        this.port(other.port);
    }

    public MutableDirectBuffer getHostBuffer() {
        return this.hostBuffer;
    }

    public SocketAddress host(DirectBuffer src, int offset, int length) {
        this.checkHostLength(length);
        this.hostLength(length);
        this.hostBuffer.putBytes(0, src, offset, length);
        return this;
    }

    public SocketAddress host(byte[] src, int offset, int length) {
        this.checkHostLength(length);
        this.hostLength(length);
        this.hostBuffer.putBytes(0, src, offset, length);
        return this;
    }

    public SocketAddress host(String host) {
        byte[] hostBytes = StringUtil.getBytes((String)host);
        return this.host(hostBytes, 0, hostBytes.length);
    }

    public SocketAddress setHost(String host) {
        return this.host(host);
    }

    public String host() {
        int hostLength = this.hostLength();
        byte[] tmp = new byte[hostLength];
        this.hostBuffer.getBytes(0, tmp, 0, hostLength);
        return StringUtil.fromBytes((byte[])tmp);
    }

    public int hostLength() {
        return this.hostBuffer.capacity();
    }

    public SocketAddress hostLength(int hostLength) {
        this.hostBuffer.wrap(this.byteArray, 0, hostLength);
        return this;
    }

    protected void checkHostLength(int hostLength) {
        if (hostLength > 128) {
            throw new RuntimeException(String.format("Host length exceeds max length (%d > %d bytes)", hostLength, 128));
        }
    }

    public int port() {
        return this.port;
    }

    public SocketAddress port(int port) {
        this.port = port;
        return this;
    }

    public SocketAddress setPort(int port) {
        return this.port(port);
    }

    public SocketAddress reset() {
        this.port = 0;
        this.hostLength(0);
        return this;
    }

    public void wrap(SocketAddress endpoint) {
        this.reset();
        this.host((DirectBuffer)endpoint.getHostBuffer(), 0, endpoint.hostLength());
        this.port(endpoint.port());
    }

    public InetSocketAddress toInetSocketAddress() {
        return new InetSocketAddress(this.host(), this.port);
    }

    @Override
    public int compareTo(SocketAddress o) {
        MutableDirectBuffer thatHostBuffer;
        MutableDirectBuffer thisHostBuffer = this.getHostBuffer();
        int cmp = thisHostBuffer.compareTo((Object)(thatHostBuffer = o.getHostBuffer()));
        if (cmp == 0) {
            cmp = Integer.compare(this.port(), o.port());
        }
        return cmp;
    }

    public int hashCode() {
        int result = this.hostBuffer.hashCode();
        result = 31 * result + this.port;
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SocketAddress that = (SocketAddress)o;
        if (this.port != that.port) {
            return false;
        }
        return this.hostBuffer.equals((Object)that.hostBuffer);
    }

    public String toString() {
        return this.host() + ":" + this.port();
    }

    public static SocketAddress from(String address) {
        int port;
        String[] parts = address.split(":", 2);
        if (parts.length != 2) {
            throw new IllegalArgumentException("Address has to be in format host:port but was: " + address);
        }
        String portString = parts[1];
        try {
            port = Integer.parseInt(portString);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Port of address '" + address + "' has to be a number but was: " + portString);
        }
        return new SocketAddress(parts[0], port);
    }
}

