/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.transport.impl;

import io.zeebe.dispatcher.FragmentHandler;
import io.zeebe.dispatcher.Subscription;
import io.zeebe.transport.ClientInputMessageSubscription;
import io.zeebe.transport.ClientMessageHandler;
import io.zeebe.transport.ClientOutput;
import io.zeebe.transport.RemoteAddress;
import io.zeebe.transport.RemoteAddressList;
import io.zeebe.util.sched.ActorCondition;

public class ClientInputMessageSubscriptionImpl
implements ClientInputMessageSubscription {
    protected final Subscription subscription;
    protected final FragmentHandler messageHandler;

    public ClientInputMessageSubscriptionImpl(Subscription subscription, ClientMessageHandler messageHandler, ClientOutput output, RemoteAddressList remoteAddresses) {
        this.subscription = subscription;
        this.messageHandler = (buffer, offset, length, streamId, isMarkedFailed) -> {
            RemoteAddress remoteAddress = remoteAddresses.getByStreamId(streamId);
            boolean success = messageHandler.onMessage(output, remoteAddress, buffer, offset, length);
            return success ? 0 : 1;
        };
    }

    @Override
    public int poll() {
        return this.subscription.peekAndConsume(this.messageHandler, Integer.MAX_VALUE);
    }

    public boolean hasAvailable() {
        return this.subscription.hasAvailable();
    }

    public void registerConsumer(ActorCondition listener) {
        this.subscription.registerConsumer(listener);
    }

    public void removeConsumer(ActorCondition listener) {
        this.subscription.removeConsumer(listener);
    }
}

