/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.transport.impl;

import io.zeebe.dispatcher.Dispatcher;
import io.zeebe.dispatcher.FragmentHandler;
import io.zeebe.transport.ClientInputListener;
import io.zeebe.transport.impl.IncomingResponse;
import io.zeebe.transport.impl.RequestResponseHeaderDescriptor;
import io.zeebe.transport.impl.TransportHeaderDescriptor;
import io.zeebe.transport.impl.sender.Sender;
import java.util.List;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

public class ClientReceiveHandler
implements FragmentHandler {
    private final TransportHeaderDescriptor transportHeaderDescriptor = new TransportHeaderDescriptor();
    private final RequestResponseHeaderDescriptor requestResponseHeaderDescriptor = new RequestResponseHeaderDescriptor();
    protected final Sender requestPool;
    protected final Dispatcher receiveBuffer;
    protected final List<ClientInputListener> listeners;

    public ClientReceiveHandler(Sender requestPool, Dispatcher receiveBuffer, List<ClientInputListener> listeners) {
        this.requestPool = requestPool;
        this.receiveBuffer = receiveBuffer;
        this.listeners = listeners;
    }

    public int onFragment(DirectBuffer buffer, int readOffset, int length, int streamId, boolean isMarkedFailed) {
        this.transportHeaderDescriptor.wrap(buffer, readOffset);
        readOffset += TransportHeaderDescriptor.headerLength();
        length -= TransportHeaderDescriptor.headerLength();
        int protocolId = this.transportHeaderDescriptor.protocolId();
        switch (protocolId) {
            case 0: {
                this.requestResponseHeaderDescriptor.wrap(buffer, readOffset);
                long requestId = this.requestResponseHeaderDescriptor.requestId();
                UnsafeBuffer responseBuffer = new UnsafeBuffer(new byte[length -= RequestResponseHeaderDescriptor.headerLength()]);
                buffer.getBytes(readOffset += RequestResponseHeaderDescriptor.headerLength(), (MutableDirectBuffer)responseBuffer, 0, length);
                this.invokeResponseListeners(streamId, requestId, buffer, readOffset, length);
                this.requestPool.submitResponse(new IncomingResponse(requestId, (DirectBuffer)responseBuffer));
                return 0;
            }
            case 1: {
                if (!isMarkedFailed) {
                    int result = this.onMessage(buffer, readOffset, length, streamId);
                    if (result == 0) {
                        this.invokeMessageListeners(streamId, buffer, readOffset, length);
                    }
                    return result;
                }
                return 0;
            }
        }
        return 0;
    }

    protected int onMessage(DirectBuffer buffer, int offset, int length, int streamId) {
        if (this.receiveBuffer == null) {
            return 0;
        }
        long offerPosition = this.receiveBuffer.offer(buffer, offset, length, streamId);
        if (offerPosition < 0L) {
            return 1;
        }
        return 0;
    }

    protected void invokeMessageListeners(int streamId, DirectBuffer buf, int offset, int length) {
        if (this.listeners != null) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                this.listeners.get(i).onMessage(streamId, buf, offset, length);
            }
        }
    }

    protected void invokeResponseListeners(int streamId, long requestId, DirectBuffer buf, int offset, int length) {
        if (this.listeners != null) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                this.listeners.get(i).onResponse(streamId, requestId, buf, offset, length);
            }
        }
    }
}

