/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.transport.impl;

import io.zeebe.transport.EndpointRegistry;
import io.zeebe.transport.Loggers;
import io.zeebe.transport.RemoteAddress;
import io.zeebe.transport.RemoteAddressList;
import io.zeebe.transport.SocketAddress;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;

public class EndpointRegistryImpl
implements EndpointRegistry {
    public static final Logger LOG = Loggers.TRANSPORT_ENDPOINT_LOGGER;
    private final String name;
    private final RemoteAddressList remoteAddressList;
    private final Map<Integer, RemoteAddress> endpoints = new ConcurrentHashMap<Integer, RemoteAddress>();

    public EndpointRegistryImpl(String name, RemoteAddressList remoteAddressList) {
        this.name = name;
        this.remoteAddressList = remoteAddressList;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public RemoteAddress getEndpoint(Integer nodeId) {
        return nodeId != null ? this.endpoints.get(nodeId) : null;
    }

    @Override
    public SocketAddress setEndpoint(int nodeId, SocketAddress socketAddress) {
        LOG.info("Registering endpoint for node '{}' with address '{}' on transport '{}'", new Object[]{nodeId, socketAddress, this.name});
        RemoteAddress remoteAddress = this.remoteAddressList.register(socketAddress);
        RemoteAddress lastRemoteAddress = this.endpoints.put(nodeId, remoteAddress);
        if (lastRemoteAddress != null && lastRemoteAddress.getStreamId() != remoteAddress.getStreamId()) {
            return this.deactivateRemote(nodeId, lastRemoteAddress);
        }
        return null;
    }

    @Override
    public SocketAddress removeEndpoint(int nodeId) {
        RemoteAddress remoteAddress = this.endpoints.remove(nodeId);
        if (remoteAddress != null) {
            return this.deactivateRemote(nodeId, remoteAddress);
        }
        return null;
    }

    @Override
    public SocketAddress retire(int nodeId) {
        RemoteAddress remoteAddress = this.endpoints.remove(nodeId);
        if (remoteAddress != null) {
            return this.retireRemote(nodeId, remoteAddress);
        }
        return null;
    }

    private SocketAddress deactivateRemote(int nodeId, RemoteAddress remoteAddress) {
        LOG.info("Deactivating endpoint for node '{}' with address '{}' on transport '{}'", new Object[]{nodeId, remoteAddress, this.name});
        this.remoteAddressList.deactivate(remoteAddress);
        return remoteAddress.getAddress();
    }

    private SocketAddress retireRemote(int nodeId, RemoteAddress remoteAddress) {
        LOG.info("Retiring endpoint for node '{}' with address '{}' on transport '{}'", new Object[]{nodeId, remoteAddress, this.name});
        this.remoteAddressList.retire(remoteAddress);
        return remoteAddress.getAddress();
    }
}

