/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.transport.impl;

import io.zeebe.dispatcher.FragmentHandler;
import io.zeebe.transport.RemoteAddress;
import io.zeebe.transport.RemoteAddressList;
import io.zeebe.transport.ServerControlMessageListener;
import io.zeebe.transport.ServerMessageHandler;
import io.zeebe.transport.ServerOutput;
import io.zeebe.transport.ServerRequestHandler;
import io.zeebe.transport.impl.ControlMessages;
import io.zeebe.transport.impl.RequestResponseHeaderDescriptor;
import io.zeebe.transport.impl.TransportHeaderDescriptor;
import org.agrona.DirectBuffer;

public class ServerReceiveHandler
implements FragmentHandler {
    private final TransportHeaderDescriptor transportHeaderDescriptor = new TransportHeaderDescriptor();
    private final RequestResponseHeaderDescriptor requestResponseHeaderDescriptor = new RequestResponseHeaderDescriptor();
    private final RemoteAddressList remoteAddressList;
    private final ServerMessageHandler messageHandler;
    private final ServerRequestHandler requestHandler;
    private final ServerControlMessageListener controlMessageListener;
    protected final ServerOutput output;

    public ServerReceiveHandler(ServerOutput output, RemoteAddressList remoteAddressList, ServerMessageHandler messageHandler, ServerRequestHandler requestHandler, ServerControlMessageListener controlMessageListener) {
        this.output = output;
        this.remoteAddressList = remoteAddressList;
        this.messageHandler = messageHandler;
        this.requestHandler = requestHandler;
        this.controlMessageListener = controlMessageListener;
    }

    public int onFragment(DirectBuffer buffer, int readOffset, int length, int streamId, boolean isMarkedFailed) {
        int result = 0;
        RemoteAddress remoteAddress = this.remoteAddressList.getByStreamId(streamId);
        this.transportHeaderDescriptor.wrap(buffer, readOffset);
        readOffset += TransportHeaderDescriptor.headerLength();
        length -= TransportHeaderDescriptor.headerLength();
        int protocolId = this.transportHeaderDescriptor.protocolId();
        switch (protocolId) {
            case 0: {
                if (this.requestHandler == null) break;
                this.requestResponseHeaderDescriptor.wrap(buffer, readOffset);
                long requestId = this.requestResponseHeaderDescriptor.requestId();
                result = this.requestHandler.onRequest(this.output, remoteAddress, buffer, readOffset += RequestResponseHeaderDescriptor.headerLength(), length -= RequestResponseHeaderDescriptor.headerLength(), requestId) ? 0 : 1;
                break;
            }
            case 1: {
                if (this.messageHandler == null) break;
                result = this.messageHandler.onMessage(this.output, remoteAddress, buffer, readOffset, length) ? 0 : 1;
                break;
            }
            case 2: {
                if (this.controlMessageListener == null) break;
                int messageType = buffer.getInt(readOffset, ControlMessages.CONTROL_MESSAGE_BYTEORDER);
                this.controlMessageListener.onMessage(this.output, remoteAddress, messageType);
                break;
            }
            default: {
                result = 2;
            }
        }
        return result;
    }
}

