/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.transport.impl.actor;

import io.zeebe.transport.TransportListener;
import io.zeebe.transport.impl.actor.ClientConductor;
import io.zeebe.transport.impl.actor.Conductor;
import io.zeebe.transport.impl.actor.Receiver;
import io.zeebe.transport.impl.actor.ServerConductor;
import io.zeebe.transport.impl.sender.Sender;
import io.zeebe.util.metrics.MetricsManager;
import io.zeebe.util.sched.future.ActorFuture;

public abstract class ActorContext {
    private Conductor conductor;
    private Sender sender;
    private Receiver receiver;
    private MetricsManager metricsManager;

    public void setConductor(Conductor clientConductor) {
        this.conductor = clientConductor;
    }

    public void setReceiver(Receiver receiver) {
        this.receiver = receiver;
    }

    public void removeListener(TransportListener listener) {
        this.conductor.removeListener(listener);
    }

    public ActorFuture<Void> registerListener(TransportListener channelListener) {
        return this.conductor.registerListener(channelListener);
    }

    public ActorFuture<Void> onClose() {
        return this.conductor.close();
    }

    public ActorFuture<Void> closeAllOpenChannels() {
        return this.conductor.closeCurrentChannels();
    }

    public ActorFuture<Void> interruptAllChannels() {
        return this.conductor.interruptAllChannels();
    }

    public ActorFuture<Void> closeReceiver() {
        return this.receiver.close();
    }

    public Conductor getConductor() {
        return this.conductor;
    }

    public ClientConductor getClientConductor() {
        return (ClientConductor)this.conductor;
    }

    public ServerConductor getServerConductor() {
        return (ServerConductor)this.conductor;
    }

    public Receiver getReceiver() {
        return this.receiver;
    }

    public MetricsManager getMetricsManager() {
        return this.metricsManager;
    }

    public void setMetricsManager(MetricsManager metricsManager) {
        this.metricsManager = metricsManager;
    }

    public Sender getSender() {
        return this.sender;
    }

    public void setSender(Sender sender) {
        this.sender = sender;
    }

    public ActorFuture<Void> closeSender() {
        return this.sender.close();
    }
}

