/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.transport.impl.memory;

import io.zeebe.transport.Loggers;
import io.zeebe.transport.impl.memory.TransportMemoryPool;
import io.zeebe.util.ByteValue;
import java.nio.ByteBuffer;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;

public class BlockingMemoryPool
implements TransportMemoryPool {
    private static final Logger LOG = Loggers.TRANSPORT_MEMORY_LOGGER;
    private final ReentrantLock lock = new ReentrantLock(true);
    private final Condition memoryReclaimed = this.lock.newCondition();
    private long availableCapacity = 0L;
    private long maxBlockTimeMs;

    public BlockingMemoryPool(ByteValue capacity, long maxBlockTimeMs) {
        this.availableCapacity = capacity.toBytes();
        this.maxBlockTimeMs = maxBlockTimeMs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ByteBuffer allocate(int requestedCapacity) {
        LOG.trace("Attempting to allocate {} bytes", (Object)requestedCapacity);
        long deadline = System.currentTimeMillis() + this.maxBlockTimeMs;
        boolean canAllocte = false;
        try {
            this.lock.lock();
            do {
                LOG.trace("Allocation attempt");
                long newRemaining = this.availableCapacity - (long)requestedCapacity;
                boolean bl = canAllocte = newRemaining >= 0L;
                if (canAllocte) {
                    this.availableCapacity = newRemaining;
                    continue;
                }
                try {
                    this.memoryReclaimed.await(1L, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException e) {
                    LOG.debug("Interrupted while waiting for memory to be reclaimed.");
                    break;
                }
            } while (System.currentTimeMillis() < deadline && !canAllocte);
        }
        finally {
            this.lock.unlock();
        }
        if (canAllocte) {
            LOG.trace("Attocated {} bytes", (Object)requestedCapacity);
            return ByteBuffer.allocate(requestedCapacity);
        }
        LOG.trace("Failed to allocate {} bytes", (Object)requestedCapacity);
        return null;
    }

    @Override
    public void reclaim(ByteBuffer buffer) {
        int bytesReclaimed = buffer.capacity();
        LOG.trace("Reclaiming {} bytes", (Object)bytesReclaimed);
        try {
            this.lock.lock();
            this.availableCapacity += (long)bytesReclaimed;
            this.memoryReclaimed.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }
}

