/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.transport.impl.selector;

import io.zeebe.transport.impl.ServerSocketBinding;
import io.zeebe.transport.impl.actor.ServerConductor;
import java.io.IOException;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.function.ToIntFunction;
import org.agrona.nio.TransportPoller;

public class AcceptTransportPoller
extends TransportPoller {
    private final ServerConductor serverConductor;
    private final ToIntFunction<SelectionKey> processKeyFn = this::processKey;

    public AcceptTransportPoller(ServerConductor serverConductor) {
        this.serverConductor = serverConductor;
    }

    public void pollBlocking() {
        if (this.selector.isOpen()) {
            try {
                this.selector.select();
            }
            catch (IOException e) {
                this.selectedKeySet.reset();
                throw new RuntimeException(e);
            }
        }
    }

    public void processKeys() {
        this.selectedKeySet.forEach(this.processKeyFn);
    }

    protected int processKey(SelectionKey key) {
        if (key != null && key.isValid()) {
            ServerSocketBinding serverSocketBinding = (ServerSocketBinding)key.attachment();
            SocketChannel serverChannel = serverSocketBinding.accept();
            this.serverConductor.onServerChannelOpened(serverChannel);
            return 1;
        }
        return 0;
    }

    public void addServerSocketBinding(ServerSocketBinding binding) {
        binding.registerSelector(this.selector, 16);
    }
}

