/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.transport.impl.sender;

import io.zeebe.transport.ClientResponse;
import io.zeebe.transport.Loggers;
import io.zeebe.transport.RemoteAddress;
import io.zeebe.transport.impl.ControlMessages;
import io.zeebe.transport.impl.IncomingResponse;
import io.zeebe.transport.impl.RemoteAddressImpl;
import io.zeebe.transport.impl.TransportChannel;
import io.zeebe.transport.impl.actor.ActorContext;
import io.zeebe.transport.impl.memory.TransportMemoryPool;
import io.zeebe.transport.impl.sender.OutgoingMessage;
import io.zeebe.transport.impl.sender.OutgoingRequest;
import io.zeebe.util.ByteValue;
import io.zeebe.util.sched.Actor;
import io.zeebe.util.sched.channel.ConcurrentQueueChannel;
import io.zeebe.util.sched.clock.ActorClock;
import io.zeebe.util.sched.future.ActorFuture;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.TimeUnit;
import org.agrona.DeadlineTimerWheel;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.collections.Int2ObjectHashMap;
import org.agrona.collections.Long2ObjectHashMap;
import org.agrona.concurrent.ManyToOneConcurrentLinkedQueue;
import org.agrona.concurrent.UnsafeBuffer;
import org.slf4j.Logger;

public class Sender
extends Actor
implements DeadlineTimerWheel.TimerHandler {
    private static final int MAX_REQUEST_CONSUME_BATCH_SIZE = 100;
    private static final int DEFAULT_BATCH_SIZE = (int)ByteValue.ofKilobytes((long)128L).toBytes();
    private static final Logger LOG = Loggers.TRANSPORT_LOGGER;
    private long nextRequestId = 0L;
    private final ConcurrentQueueChannel<IncomingResponse> submittedResponses = new ConcurrentQueueChannel((Queue)new ManyToOneConcurrentLinkedQueue());
    private final ConcurrentQueueChannel<OutgoingRequest> submittedRequests = new ConcurrentQueueChannel((Queue)new ManyToOneConcurrentLinkedQueue());
    private final ConcurrentQueueChannel<OutgoingMessage> submittedMessages = new ConcurrentQueueChannel((Queue)new ManyToOneConcurrentLinkedQueue());
    private final Long2ObjectHashMap<OutgoingRequest> inFlightRequests = new Long2ObjectHashMap();
    private final Long2ObjectHashMap<OutgoingRequest> requestsByTimeoutIds = new Long2ObjectHashMap();
    private final Int2ObjectHashMap<ChannelWriteQueue> channelMap = new Int2ObjectHashMap();
    private final List<ChannelWriteQueue> channelList = new ArrayList<ChannelWriteQueue>();
    private final Deque<Batch> recycledBuffers = new LinkedList<Batch>();
    private DeadlineTimerWheel requestTimeouts;
    private final Runnable sendNext = this::sendNext;
    protected final Duration keepAlivePeriod;
    private final TransportMemoryPool messageMemoryPool;
    private final TransportMemoryPool requestMemoryPool;

    public Sender(ActorContext actorContext, TransportMemoryPool messageMemoryPool, TransportMemoryPool requestMemoryPool, Duration keepalivePeriod) {
        this.messageMemoryPool = messageMemoryPool;
        this.requestMemoryPool = requestMemoryPool;
        this.keepAlivePeriod = keepalivePeriod;
        actorContext.setSender(this);
    }

    protected void onActorStarted() {
        this.requestTimeouts = new DeadlineTimerWheel(TimeUnit.MILLISECONDS, ActorClock.currentTimeMillis(), 1, 32);
        this.actor.consume(this.submittedMessages, this::processSubmittedMessages);
        this.actor.consume(this.submittedRequests, this::processSubmittedRequests);
        this.actor.consume(this.submittedResponses, this::processIncomingResponses);
        this.actor.runAtFixedRate(Duration.ofMillis(100L), this::processTimeouts);
        if (this.keepAlivePeriod != null) {
            this.actor.runAtFixedRate(this.keepAlivePeriod, this::sendKeepalives);
        }
    }

    private void processTimeouts() {
        long now = ActorClock.currentTimeMillis();
        while (this.requestTimeouts.poll(now, (DeadlineTimerWheel.TimerHandler)this, Integer.MAX_VALUE) > 0) {
        }
    }

    private void processIncomingResponses() {
        while (!this.submittedResponses.isEmpty()) {
            IncomingResponse response = (IncomingResponse)this.submittedResponses.poll();
            if (response == null) continue;
            this.onResponseReceived(response);
        }
        this.sendNext();
    }

    private void processSubmittedRequests() {
        for (int i = 0; i < 100 && !this.submittedRequests.isEmpty(); ++i) {
            OutgoingRequest request = (OutgoingRequest)this.submittedRequests.poll();
            if (request == null) continue;
            LOG.trace("New request submitted");
            this.onRequestSubmitted(request);
        }
        this.sendNext();
    }

    private void processSubmittedMessages() {
        while (!this.submittedMessages.isEmpty()) {
            OutgoingMessage message = (OutgoingMessage)this.submittedMessages.poll();
            if (message == null) continue;
            LOG.trace("New message submitted");
            this.onMessageSubmitted(message);
        }
        this.sendNext();
    }

    private void onResponseReceived(IncomingResponse response) {
        OutgoingRequest request = (OutgoingRequest)this.inFlightRequests.remove(response.getRequestId());
        if (request != null) {
            boolean shouldRetry = false;
            try {
                shouldRetry = !request.tryComplete(response);
            }
            catch (Exception e) {
                request.fail(e);
                this.reclaimRequestBuffer(request.getRequestBuffer().byteBuffer());
                return;
            }
            if (shouldRetry) {
                this.actor.runDelayed(Duration.ofMillis(1L), () -> this.submittedRequests.offer((Object)request));
            } else {
                this.reclaimRequestBuffer(request.getRequestBuffer().byteBuffer());
                long timerId = request.getTimerId();
                if (timerId != -1L) {
                    this.requestTimeouts.cancelTimer(timerId);
                    this.requestsByTimeoutIds.remove(timerId);
                }
            }
        }
    }

    private void onRequestSubmitted(OutgoingRequest request) {
        if (!request.hasTimeoutScheduled()) {
            long timerId = this.requestTimeouts.scheduleTimer(ActorClock.currentTimeMillis() + request.getTimeout().toMillis());
            request.setTimerId(timerId);
            this.requestsByTimeoutIds.put(timerId, (Object)request);
        }
        if (!request.isTimedout()) {
            RemoteAddress remoteAddress = request.getNextRemoteAddress();
            if (remoteAddress != null) {
                ChannelWriteQueue sendQueue = (ChannelWriteQueue)this.channelMap.get(remoteAddress.getStreamId());
                if (sendQueue != null) {
                    request.markRemoteAddress(remoteAddress);
                    sendQueue.offer(request);
                } else {
                    this.actor.runDelayed(Duration.ofMillis(10L), () -> this.submittedRequests.offer((Object)request));
                }
            } else {
                this.actor.runDelayed(Duration.ofMillis(10L), () -> this.submittedRequests.offer((Object)request));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onMessageSubmitted(OutgoingMessage message) {
        int remoteStreamId = message.getRemoteStreamId();
        ChannelWriteQueue sendQueue = (ChannelWriteQueue)this.channelMap.get(remoteStreamId);
        if (sendQueue != null) {
            try {
                sendQueue.offer(message);
            }
            finally {
                this.reclaimMessageBuffer(message.getAllocatedBuffer());
            }
        } else if (ActorClock.currentTimeMillis() < message.getDeadline()) {
            this.actor.runDelayed(Duration.ofMillis(10L), () -> this.submittedMessages.offer((Object)message));
        } else {
            LOG.trace("Drop message because the channel is not open.");
            this.reclaimMessageBuffer(message.getAllocatedBuffer());
        }
    }

    private void sendNext() {
        boolean hasPending = false;
        for (int i = 0; i < this.channelList.size(); ++i) {
            ChannelWriteQueue channelSendQueue = this.channelList.get(i);
            channelSendQueue.write();
            hasPending |= channelSendQueue.hasPending();
        }
        if (hasPending) {
            this.actor.submit(this.sendNext);
        }
    }

    private void sendKeepalives() {
        for (ChannelWriteQueue channelWriteQueue : this.channelList) {
            if (channelWriteQueue.hasPending()) continue;
            channelWriteQueue.getPendingWrites().addLast(new ControlMessage(ControlMessages.KEEP_ALIVE));
        }
        this.sendNext();
    }

    public ActorFuture<ClientResponse> submitRequest(OutgoingRequest request) {
        this.submittedRequests.add((Object)request);
        return request.getResponseFuture();
    }

    public void submitMessage(OutgoingMessage outgoingMessage) {
        this.submittedMessages.add((Object)outgoingMessage);
    }

    public void submitResponse(IncomingResponse incomingClientResponse) {
        this.submittedResponses.add((Object)incomingClientResponse);
    }

    public ActorFuture<Void> close() {
        return this.actor.close();
    }

    public ActorFuture<Void> onChannelConnected(TransportChannel ch) {
        return this.actor.call(() -> {
            ChannelWriteQueue sendQueue = new ChannelWriteQueue(ch);
            this.channelMap.put(ch.getStreamId(), (Object)sendQueue);
            this.channelList.add(sendQueue);
        });
    }

    public ActorFuture<Void> onChannelClosed(TransportChannel channel) {
        return this.actor.call(() -> {
            ChannelWriteQueue sendQueue = (ChannelWriteQueue)this.channelMap.remove(channel.getStreamId());
            if (sendQueue != null) {
                this.channelList.remove(sendQueue);
                sendQueue.pendingWrites.forEach(Batch::onChannelClosed);
            }
        });
    }

    public boolean onTimerExpiry(TimeUnit timeUnit, long now, long timerId) {
        OutgoingRequest request = (OutgoingRequest)this.requestsByTimeoutIds.get(timerId);
        if (request != null) {
            this.reclaimRequestBuffer(request.getRequestBuffer().byteBuffer());
            request.timeout();
            this.inFlightRequests.remove(request.getLastRequestId());
        }
        return true;
    }

    public ByteBuffer allocateMessageBuffer(int length) {
        return this.messageMemoryPool.allocate(length);
    }

    public void reclaimMessageBuffer(ByteBuffer allocatedBuffer) {
        this.messageMemoryPool.reclaim(allocatedBuffer);
    }

    public ByteBuffer allocateRequestBuffer(int requestedCapacity) {
        return this.requestMemoryPool.allocate(requestedCapacity);
    }

    public void reclaimRequestBuffer(ByteBuffer allocatedBuffer) {
        this.requestMemoryPool.reclaim(allocatedBuffer);
    }

    public void failPendingRequestsToRemote(RemoteAddressImpl remoteAddress, String reason) {
    }

    class ControlMessage
    extends Batch {
        ControlMessage(DirectBuffer controlMessageTemplate) {
            super(controlMessageTemplate.capacity());
            this.view.putBytes(0, controlMessageTemplate, 0, controlMessageTemplate.capacity());
            this.writeOffset = controlMessageTemplate.capacity();
        }

        @Override
        public void recycle() {
        }
    }

    private class Batch {
        final List<OutgoingRequest> requestsInBatch = new ArrayList<OutgoingRequest>();
        final UnsafeBuffer view = new UnsafeBuffer();
        final ByteBuffer batchBuffer;
        int writeOffset = 0;

        Batch(int size) {
            this.batchBuffer = ByteBuffer.allocateDirect(size);
            this.view.wrap(this.batchBuffer);
        }

        public boolean addToBatch(OutgoingRequest request, TransportChannel channel) {
            DirectBuffer requestBuffer = request.getRequestBuffer();
            int requestLength = requestBuffer.capacity();
            if (this.writeOffset + requestLength <= this.batchBuffer.capacity()) {
                long requestId = ++Sender.this.nextRequestId;
                request.setLastRequestId(requestId);
                request.getHeaderWriter().setStreamId(channel.getStreamId()).setRequestId(requestId);
                requestBuffer.getBytes(0, this.batchBuffer, this.writeOffset, requestLength);
                this.writeOffset += requestLength;
                this.requestsInBatch.add(request);
                Sender.this.inFlightRequests.put(requestId, (Object)request);
                return true;
            }
            return false;
        }

        public boolean addToBatch(OutgoingMessage message) {
            MutableDirectBuffer buffer = message.getBuffer();
            int requiredLength = buffer.capacity();
            if (this.writeOffset + requiredLength <= this.batchBuffer.capacity()) {
                buffer.getBytes(0, this.batchBuffer, this.writeOffset, requiredLength);
                this.writeOffset += requiredLength;
                return true;
            }
            return false;
        }

        public boolean writeTo(TransportChannel channel) {
            return channel.write(this.batchBuffer) > 0;
        }

        public void prepareWrite() {
            this.batchBuffer.position(0);
            this.batchBuffer.limit(this.writeOffset);
        }

        public boolean hasRemaining() {
            return this.batchBuffer.hasRemaining();
        }

        public void recycle() {
            this.writeOffset = 0;
            this.view.setMemory(0, this.view.capacity(), (byte)0);
            this.requestsInBatch.clear();
            Sender.this.recycledBuffers.push(this);
        }

        public void onChannelClosed() {
            this.requestsInBatch.forEach(Sender.this::submitRequest);
            this.recycle();
        }
    }

    public class ChannelWriteQueue {
        private final Deque<Batch> pendingWrites = new LinkedList<Batch>();
        private final TransportChannel channel;
        private Batch currentWrite;

        public ChannelWriteQueue(TransportChannel channel) {
            this.channel = channel;
        }

        public boolean hasPending() {
            return this.currentWrite != null || !this.pendingWrites.isEmpty();
        }

        public void write() {
            if (this.hasPending()) {
                if (this.currentWrite == null) {
                    this.currentWrite = this.pendingWrites.poll();
                    this.currentWrite.prepareWrite();
                }
                this.currentWrite.writeTo(this.channel);
                if (!this.currentWrite.hasRemaining()) {
                    this.currentWrite.recycle();
                    this.currentWrite = null;
                }
            }
        }

        public void offer(OutgoingRequest request) {
            Batch existingBatch = this.pendingWrites.peekLast();
            if (existingBatch == null || !existingBatch.addToBatch(request, this.channel)) {
                Batch batch;
                Iterator recycledBuffersIterator = Sender.this.recycledBuffers.iterator();
                while (recycledBuffersIterator.hasNext()) {
                    batch = (Batch)recycledBuffersIterator.next();
                    if (!batch.addToBatch(request, this.channel)) continue;
                    recycledBuffersIterator.remove();
                    this.pendingWrites.addLast(batch);
                    return;
                }
                batch = new Batch(Math.max(DEFAULT_BATCH_SIZE, request.getRequestBuffer().capacity()));
                batch.addToBatch(request, this.channel);
                this.pendingWrites.addLast(batch);
            }
        }

        public void offer(OutgoingMessage message) {
            Batch batch = this.pendingWrites.peekLast();
            if (batch == null || !batch.addToBatch(message)) {
                boolean hasRecycled = false;
                Iterator recycledBuffersIterator = Sender.this.recycledBuffers.iterator();
                while (recycledBuffersIterator.hasNext()) {
                    batch = (Batch)recycledBuffersIterator.next();
                    if (!batch.addToBatch(message)) continue;
                    recycledBuffersIterator.remove();
                    hasRecycled = true;
                    break;
                }
                if (!hasRecycled) {
                    batch = new Batch(Math.max(DEFAULT_BATCH_SIZE, message.getBuffer().capacity()));
                    batch.addToBatch(message);
                }
                this.pendingWrites.addLast(batch);
            }
        }

        public Deque<Batch> getPendingWrites() {
            return this.pendingWrites;
        }
    }
}

