/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.transport.impl.util;

import io.zeebe.transport.SocketAddress;
import io.zeebe.util.ZbLogger;
import java.io.IOException;
import java.net.ServerSocket;
import java.util.Iterator;
import org.slf4j.Logger;

public class SocketUtil {
    public static final Logger LOG = new ZbLogger("io.zeebe.transport.impl.util.SocketUtil");
    public static final String TEST_FORK_NUMBER_PROPERTY_NAME = "testForkNumber";
    public static final String TEST_MAVEN_ID_PROPERTY_NAME = "testMavenId";
    public static final String DEFAULT_HOST = "localhost";
    public static final int BASE_PORT = 25600;
    public static final int RANGE_SIZE = 100;
    private static final int TEST_FORK_NUMBER;
    private static final PortRange PORT_RANGE;

    private static int getTestForkNumber() {
        int testForkNumber = 0;
        try {
            String testForkNumberProperty = System.getProperty(TEST_FORK_NUMBER_PROPERTY_NAME);
            if (testForkNumberProperty != null) {
                testForkNumber = Integer.valueOf(testForkNumberProperty);
            } else {
                LOG.warn("No system property '{}' set, using default value {}", (Object)TEST_FORK_NUMBER_PROPERTY_NAME, (Object)testForkNumber);
            }
        }
        catch (Exception e) {
            LOG.warn("Failed to read test fork number system property", (Throwable)e);
        }
        return testForkNumber;
    }

    private static int getTestMavenId() {
        int testMavenId = 0;
        try {
            String testMavenIdProperty = System.getProperty(TEST_MAVEN_ID_PROPERTY_NAME);
            if (testMavenIdProperty != null) {
                testMavenId = Integer.valueOf(testMavenIdProperty);
            } else {
                LOG.warn("No system property '{}' set, using default value {}", (Object)TEST_MAVEN_ID_PROPERTY_NAME, (Object)testMavenId);
            }
        }
        catch (Exception e) {
            LOG.warn("Failed to read test maven id system property", (Throwable)e);
        }
        return testMavenId;
    }

    public static SocketAddress getNextAddress() {
        return PORT_RANGE.next();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean portAvailable(int port) {
        try (ServerSocket ss = new ServerSocket(port);){
            ss.setReuseAddress(true);
            boolean bl = true;
            return bl;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    static {
        int testForkNumber = SocketUtil.getTestForkNumber();
        int testMavenId = SocketUtil.getTestMavenId();
        LOG.info("Starting socket assignment with testForkNumber {} and testMavenId {}", (Object)testForkNumber, (Object)testMavenId);
        assert (testForkNumber < 39) : "System property test fork number has to be smaller then 39";
        assert (testMavenId < 10) : "System property test maven id has to be smaller then 10";
        int testOffset = testForkNumber * 10 + testMavenId;
        int min = 25600 + testOffset * 100;
        int max = min + 100;
        TEST_FORK_NUMBER = testForkNumber;
        PORT_RANGE = new PortRange(DEFAULT_HOST, min, max);
    }

    static class PortRange
    implements Iterator<SocketAddress> {
        final String host;
        final int basePort;
        final int maxOffset;
        int currentOffset;

        PortRange(String host, int min, int max) {
            assert (max <= 65535) : "Port range exceeds maximal available port 65535, got max port " + max;
            this.host = host;
            this.basePort = min;
            this.maxOffset = max - min;
            this.currentOffset = 0;
        }

        @Override
        public boolean hasNext() {
            return true;
        }

        @Override
        public SocketAddress next() {
            return new SocketAddress(this.host, this.nextPort());
        }

        private int nextPort() {
            int next;
            while (!SocketUtil.portAvailable(next = this.basePort + this.currentOffset++ % this.maxOffset)) {
            }
            LOG.info("Choosing next port {} for test fork {} with range {}", new Object[]{next, TEST_FORK_NUMBER, this});
            return next;
        }

        public String toString() {
            return "PortRange{host='" + this.host + '\'' + ", basePort=" + this.basePort + ", maxOffset=" + this.maxOffset + ", currentOffset=" + this.currentOffset + '}';
        }
    }
}

