/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.servicecontainer.impl;

import io.zeebe.servicecontainer.CompositeServiceBuilder;
import io.zeebe.servicecontainer.Injector;
import io.zeebe.servicecontainer.Service;
import io.zeebe.servicecontainer.ServiceBuilder;
import io.zeebe.servicecontainer.ServiceGroupReference;
import io.zeebe.servicecontainer.ServiceInterruptedException;
import io.zeebe.servicecontainer.ServiceName;
import io.zeebe.servicecontainer.ServiceStartContext;
import io.zeebe.servicecontainer.ServiceStopContext;
import io.zeebe.servicecontainer.impl.Loggers;
import io.zeebe.servicecontainer.impl.ServiceContainerImpl;
import io.zeebe.servicecontainer.impl.ServiceEvent;
import io.zeebe.util.sched.Actor;
import io.zeebe.util.sched.ActorScheduler;
import io.zeebe.util.sched.channel.ConcurrentQueueChannel;
import io.zeebe.util.sched.future.ActorFuture;
import io.zeebe.util.sched.future.CompletableActorFuture;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.agrona.concurrent.ManyToOneConcurrentLinkedQueue;
import org.slf4j.Logger;

public class ServiceController
extends Actor {
    public static final Logger LOG = Loggers.SERVICE_CONTAINER_LOGGER;
    public static final boolean IS_TRACE_ENABLED = LOG.isTraceEnabled();
    private final AwaitDependenciesStartedState awaitDependenciesStartedState = new AwaitDependenciesStartedState();
    private final AwaitStartState awaitStartState = new AwaitStartState();
    private final StartedState startedState = new StartedState();
    private final AwaitDependentsStopped awaitDependentsStopped = new AwaitDependentsStopped();
    private final AwaitStopState awaitStopState = new AwaitStopState();
    private final RemovedState removedState = new RemovedState();
    private final ConcurrentQueueChannel<ServiceEvent> channel = new ConcurrentQueueChannel((Queue)new ManyToOneConcurrentLinkedQueue());
    private final ServiceContainerImpl container;
    private final ServiceName name;
    private final ServiceName<?> groupName;
    private final Service service;
    private final Set<ServiceName<?>> dependencies;
    private final Map<ServiceName<?>, Collection<Injector<?>>> injectors;
    private final Map<ServiceName<?>, ServiceGroupReference<?>> injectedReferences;
    private final CompletableActorFuture<Void> stopFuture = new CompletableActorFuture();
    private final CompletableActorFuture startFuture;
    private List<ServiceController> resolvedDependencies;
    private StartContextImpl startContext;
    private StopContextImpl stopContext;
    private Consumer<ServiceEvent> state = this.awaitDependenciesStartedState;

    public ServiceController(ServiceBuilder<?> builder, ServiceContainerImpl serviceContainer, CompletableActorFuture startFuture) {
        this.container = serviceContainer;
        this.startFuture = startFuture;
        this.service = builder.getService();
        this.name = builder.getName();
        this.groupName = builder.getGroupName();
        this.injectors = builder.getInjectedDependencies();
        this.dependencies = builder.getDependencies();
        this.injectedReferences = builder.getInjectedReferences();
    }

    public String getName() {
        return "service-controller";
    }

    protected void onActorStarted() {
        this.actor.consume(this.channel, this::onServiceEvent);
        this.container.getChannel().add((Object)new ServiceEvent(ServiceEvent.ServiceEventType.SERVICE_INSTALLED, this));
    }

    protected void onActorClosed() {
        this.stopFuture.complete(null);
    }

    private void onServiceEvent() {
        ServiceEvent event = (ServiceEvent)this.channel.poll();
        if (event != null) {
            if (IS_TRACE_ENABLED) {
                LOG.trace("Got {} in state {}", (Object)event, (Object)this.state.getClass().getSimpleName());
            }
            this.state.accept(event);
        } else {
            this.actor.yield();
        }
    }

    private void logIgnoringEvent(ServiceEvent event) {
        LOG.warn("Ignoring event {} in state {}", (Object)event.getType(), (Object)this.state.getClass().getSimpleName());
    }

    private void invokeStop(boolean interrupted) {
        this.state = this.awaitStopState;
        if (this.startContext != null) {
            this.startContext.invalidate();
        }
        this.stopContext = new StopContextImpl();
        this.stopContext.wasInterrupted = interrupted;
        try {
            this.service.stop(this.stopContext);
            if (this.stopContext.action != null) {
                this.actor.runBlocking(this.stopContext.action, (Consumer)this.stopContext);
            }
            if (!this.stopContext.isAsync()) {
                this.fireEvent(ServiceEvent.ServiceEventType.SERVICE_STOPPED);
            }
        }
        catch (Throwable t) {
            LOG.error("Exception while stopping service {}: {}", (Object)this, (Object)t);
            this.fireEvent(ServiceEvent.ServiceEventType.SERVICE_STOPPED);
        }
    }

    public String toString() {
        return String.format("%s in %s", this.name, this.state.getClass().getSimpleName());
    }

    private void fireEvent(ServiceEvent.ServiceEventType evtType) {
        this.fireEvent(evtType, null);
    }

    private void fireEvent(ServiceEvent.ServiceEventType evtType, Object payload) {
        ServiceEvent event = new ServiceEvent(evtType, this, payload);
        this.channel.add((Object)event);
        this.container.getChannel().add((Object)event);
    }

    public ConcurrentQueueChannel<ServiceEvent> getChannel() {
        return this.channel;
    }

    public Set<ServiceName<?>> getDependencies() {
        return this.dependencies;
    }

    public ActorFuture<Void> remove() {
        this.actor.run(() -> this.fireEvent(ServiceEvent.ServiceEventType.SERVICE_STOPPING));
        return this.stopFuture;
    }

    public ServiceName<?> getGroupName() {
        return this.groupName;
    }

    public ServiceName<?> getServiceName() {
        return this.name;
    }

    public Map<ServiceName<?>, ServiceGroupReference<?>> getInjectedReferences() {
        return this.injectedReferences;
    }

    public Service getService() {
        return this.service;
    }

    public void addReferencedValue(ServiceGroupReference ref, ServiceName name, Object value) {
        this.actor.call(() -> ServiceController.invoke(ref.getAddHandler(), name, value));
    }

    public void removeReferencedValue(ServiceGroupReference ref, ServiceName name, Object value) {
        this.actor.call(() -> ServiceController.invoke(ref.getRemoveHandler(), name, value));
    }

    private static <S> void invoke(BiConsumer consumer, ServiceName name, Object value) {
        consumer.accept(name, value);
    }

    class StopContextImpl
    implements ServiceStopContext,
    Consumer<Throwable> {
        boolean isValid = true;
        boolean isAsync = false;
        Runnable action;
        boolean wasInterrupted = false;

        StopContextImpl() {
        }

        @Override
        public boolean wasInterrupted() {
            return this.wasInterrupted;
        }

        public void async(ActorFuture<?> future) {
            this.validCheck();
            this.notAsyncCheck();
            this.isAsync = true;
            ServiceController.this.actor.runOnCompletion(future, (v, t) -> this.accept((Throwable)t));
        }

        @Override
        public void run(Runnable action) {
            this.validCheck();
            this.notAsyncCheck();
            this.isAsync = true;
            this.action = action;
        }

        void validCheck() {
            if (!this.isValid) {
                throw new IllegalStateException("Service Context is invalid");
            }
        }

        boolean isAsync() {
            this.validCheck();
            return this.isAsync;
        }

        private void notAsyncCheck() {
            if (this.isAsync) {
                throw new IllegalStateException("Context is already async. Cannnot call asyc() more than once.");
            }
        }

        @Override
        public void accept(Throwable u) {
            ServiceController.this.fireEvent(ServiceEvent.ServiceEventType.SERVICE_STOPPED);
        }
    }

    class StartContextImpl
    implements ServiceStartContext,
    Consumer<Throwable> {
        final Set<ServiceName<?>> dependentServices = new HashSet();
        boolean isValid = true;
        boolean isAsync = false;
        boolean isInterruptible = false;
        boolean stopOnCompletion = false;
        Runnable action;

        StartContextImpl() {
        }

        public void invalidate() {
            this.isValid = false;
            ServiceController.this.startContext = null;
        }

        @Override
        public ServiceName<?> getServiceName() {
            return ServiceController.this.name;
        }

        @Override
        public <S> S getService(ServiceName<S> name) {
            this.validCheck();
            this.dependencyCheck(name);
            return (S)ServiceController.this.resolvedDependencies.stream().filter(c -> ((ServiceController)c).name.equals(name)).findFirst();
        }

        @Override
        public <S> S getService(String name, Class<S> type) {
            this.validCheck();
            return this.getService(ServiceName.newServiceName(name, type));
        }

        @Override
        public String getName() {
            return ServiceController.this.name.getName();
        }

        @Override
        public <S> ServiceBuilder<S> createService(ServiceName<S> name, Service<S> service) {
            this.validCheck();
            this.dependentServices.add(name);
            return new ServiceBuilder<S>(name, service, ServiceController.this.container).dependency(ServiceController.this.name);
        }

        @Override
        public CompositeServiceBuilder createComposite(ServiceName<Void> name) {
            this.validCheck();
            this.dependentServices.add(name);
            return new CompositeServiceBuilder(name, ServiceController.this.container, ServiceController.this.name);
        }

        @Override
        public <S> ActorFuture<Void> removeService(ServiceName<S> name) {
            Optional<ServiceController> contoller;
            this.validCheck();
            if (!this.dependentServices.contains(name) && !(contoller = ServiceController.this.resolvedDependencies.stream().filter(c -> ((ServiceController)c).name.equals(name)).findFirst()).isPresent()) {
                String errorMessage = String.format("Cannot remove service '%s' from context '%s'. Can only remove dependencies and services started through this context.", name, ServiceController.this.name);
                return CompletableActorFuture.completedExceptionally((Throwable)new IllegalArgumentException(errorMessage));
            }
            return ServiceController.this.container.removeService(name);
        }

        @Override
        public void async(ActorFuture<?> future, boolean interruptible) {
            this.validCheck();
            this.notAsyncCheck();
            this.isAsync = true;
            this.isInterruptible = interruptible;
            ServiceController.this.actor.runOnCompletion(future, (v, t) -> this.accept((Throwable)t));
        }

        @Override
        public void run(Runnable action) {
            this.validCheck();
            this.notAsyncCheck();
            this.isAsync = true;
            this.action = action;
        }

        void validCheck() {
            if (!this.isValid) {
                throw new IllegalStateException("Service Context is invalid");
            }
        }

        void dependencyCheck(ServiceName<?> name) {
            if (!ServiceController.this.dependencies.contains(name)) {
                String errorMessage = String.format("Cannot get service '%s' from context '%s'. Requested Service is not a dependency.", name, ServiceController.this.name);
                throw new IllegalArgumentException(errorMessage);
            }
        }

        boolean isAsync() {
            this.validCheck();
            return this.isAsync;
        }

        boolean isInterruptible() {
            this.validCheck();
            return this.isInterruptible;
        }

        private void notAsyncCheck() {
            if (this.isAsync) {
                throw new IllegalStateException("Context is already async. Cannnot call asyc() more than once.");
            }
        }

        @Override
        public void accept(Throwable u) {
            if (u == null) {
                ServiceController.this.fireEvent(ServiceEvent.ServiceEventType.SERVICE_STARTED);
            } else {
                ServiceController.this.fireEvent(ServiceEvent.ServiceEventType.SERVICE_START_FAILED, u);
            }
        }

        @Override
        public ActorScheduler getScheduler() {
            this.validCheck();
            return ServiceController.this.container.getActorScheduler();
        }

        @Override
        public <S> boolean hasService(ServiceName<S> name) {
            this.validCheck();
            return ServiceController.this.container.hasService(name);
        }
    }

    class RemovedState
    implements Consumer<ServiceEvent> {
        RemovedState() {
        }

        @Override
        public void accept(ServiceEvent t) {
            if (t.getType() == ServiceEvent.ServiceEventType.SERVICE_REMOVED) {
                ServiceController.this.actor.close();
            }
        }
    }

    class AwaitStopState
    implements Consumer<ServiceEvent> {
        AwaitStopState() {
        }

        @Override
        public void accept(ServiceEvent t) {
            if (t.getType() == ServiceEvent.ServiceEventType.SERVICE_STOPPED) {
                ServiceController.this.injectors.values().stream().flatMap(Collection::stream).forEach(i -> i.uninject());
                ServiceController.this.fireEvent(ServiceEvent.ServiceEventType.SERVICE_REMOVED);
                ServiceController.this.state = ServiceController.this.removedState;
            }
        }
    }

    class AwaitDependentsStopped
    implements Consumer<ServiceEvent> {
        AwaitDependentsStopped() {
        }

        @Override
        public void accept(ServiceEvent t) {
            if (t.getType() == ServiceEvent.ServiceEventType.DEPENDENTS_STOPPED) {
                ServiceController.this.invokeStop(false);
            }
        }
    }

    class StartedState
    implements Consumer<ServiceEvent> {
        StartedState() {
        }

        @Override
        public void accept(ServiceEvent t) {
            switch (t.getType()) {
                case DEPENDENCIES_UNAVAILABLE: {
                    this.onDependenciesUnavailable();
                    break;
                }
                case SERVICE_STOPPING: {
                    this.onServiceStopping();
                    break;
                }
                default: {
                    ServiceController.this.logIgnoringEvent(t);
                }
            }
        }

        public void onDependenciesUnavailable() {
            ServiceController.this.fireEvent(ServiceEvent.ServiceEventType.SERVICE_STOPPING);
            ServiceController.this.state = ServiceController.this.awaitDependentsStopped;
        }

        public void onServiceStopping() {
            ServiceController.this.state = ServiceController.this.awaitDependentsStopped;
        }
    }

    class AwaitStartState
    implements Consumer<ServiceEvent> {
        boolean stopAfterStarted = false;

        AwaitStartState() {
        }

        @Override
        public void accept(ServiceEvent t) {
            switch (t.getType()) {
                case SERVICE_STARTED: {
                    this.onStarted();
                    break;
                }
                case SERVICE_START_FAILED: {
                    this.onStartFailed((Throwable)t.getPayload());
                    break;
                }
                case DEPENDENCIES_UNAVAILABLE: 
                case SERVICE_STOPPING: 
                case DEPENDENTS_STOPPED: {
                    if (ServiceController.this.startContext.isInterruptible()) {
                        ServiceController.this.startFuture.completeExceptionally((Throwable)new ServiceInterruptedException(String.format("Service %s was interrupted", ServiceController.this.name)));
                        ServiceController.this.invokeStop(true);
                        break;
                    }
                    this.stopAfterStarted = true;
                    break;
                }
                default: {
                    ServiceController.this.logIgnoringEvent(t);
                }
            }
        }

        public void onStarted() {
            if (this.stopAfterStarted) {
                ServiceController.this.startFuture.completeExceptionally((Throwable)new RuntimeException(String.format("Could not start service %s removed while starting", ServiceController.this.name)));
                ServiceController.this.invokeStop(false);
            } else {
                ServiceController.this.state = ServiceController.this.startedState;
                ServiceController.this.startFuture.complete(ServiceController.this.getService().get());
            }
        }

        public void onStartFailed(Throwable t) {
            LOG.error("Service failed to start while in AwaitStartState", t);
            ServiceController.this.startFuture.completeExceptionally(t);
            ServiceController.this.state = ServiceController.this.awaitStopState;
            ServiceController.this.fireEvent(ServiceEvent.ServiceEventType.SERVICE_STOPPED);
        }
    }

    class AwaitDependenciesStartedState
    implements Consumer<ServiceEvent> {
        AwaitDependenciesStartedState() {
        }

        @Override
        public void accept(ServiceEvent evt) {
            switch (evt.getType()) {
                case DEPENDENCIES_AVAILABLE: {
                    this.onDependenciesAvailable(evt);
                    break;
                }
                case DEPENDENCIES_UNAVAILABLE: {
                    this.onDependenciesUnAvailable(evt);
                    break;
                }
                case SERVICE_STOPPING: {
                    this.onStopping();
                    break;
                }
                default: {
                    ServiceController.this.logIgnoringEvent(evt);
                }
            }
        }

        private void onDependenciesUnAvailable(ServiceEvent evt) {
            ServiceController.this.state = ServiceController.this.removedState;
            ServiceController.this.fireEvent(ServiceEvent.ServiceEventType.SERVICE_REMOVED);
        }

        private void onStopping() {
            ServiceController.this.state = ServiceController.this.removedState;
            ServiceController.this.fireEvent(ServiceEvent.ServiceEventType.SERVICE_REMOVED);
        }

        public void onDependenciesAvailable(ServiceEvent evt) {
            ServiceController.this.resolvedDependencies = (List)evt.getPayload();
            for (ServiceController serviceController : ServiceController.this.resolvedDependencies) {
                Collection injectors = ServiceController.this.injectors.getOrDefault(serviceController.name, Collections.emptyList());
                for (Injector injector : injectors) {
                    injector.inject(serviceController.service.get());
                    injector.setInjectedServiceName(serviceController.name);
                }
            }
            ServiceController.this.state = ServiceController.this.awaitStartState;
            ServiceController.this.startContext = new StartContextImpl();
            try {
                ServiceController.this.service.start(ServiceController.this.startContext);
                if (((ServiceController)ServiceController.this).startContext.action != null) {
                    ServiceController.this.actor.runBlocking(((ServiceController)ServiceController.this).startContext.action, (Consumer)ServiceController.this.startContext);
                }
                if (!ServiceController.this.startContext.isAsync()) {
                    ServiceController.this.fireEvent(ServiceEvent.ServiceEventType.SERVICE_STARTED);
                }
            }
            catch (Exception e) {
                ServiceController.this.fireEvent(ServiceEvent.ServiceEventType.SERVICE_START_FAILED, e);
            }
        }
    }
}

