/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.servicecontainer.impl;

import io.zeebe.servicecontainer.ServiceGroupReference;
import io.zeebe.servicecontainer.ServiceName;
import io.zeebe.servicecontainer.impl.Loggers;
import io.zeebe.servicecontainer.impl.ServiceController;
import io.zeebe.servicecontainer.impl.ServiceEvent;
import io.zeebe.servicecontainer.impl.ServiceGroup;
import io.zeebe.servicecontainer.impl.ServiceGroupReferenceImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;

public class ServiceDependencyResolver {
    public static final Logger LOG = Loggers.SERVICE_CONTAINER_LOGGER;
    private final Map<ServiceName<?>, ServiceController> installedServices = new HashMap();
    private final Map<ServiceName<?>, List<ServiceController>> unresolvedDependencies = new HashMap();
    private final Map<ServiceController, List<ServiceController>> resolvedDependencies = new HashMap<ServiceController, List<ServiceController>>();
    private final Map<ServiceController, List<ServiceController>> dependentServices = new HashMap<ServiceController, List<ServiceController>>();
    private final Set<ServiceController> startedServices = new HashSet<ServiceController>();
    private final Set<ServiceController> stoppingServices = new HashSet<ServiceController>();
    private final Map<ServiceName<?>, ServiceGroup> groups = new HashMap();

    public void onServiceEvent(ServiceEvent event) {
        switch (event.getType()) {
            case SERVICE_INSTALLED: {
                this.onServiceInstalled(event);
                break;
            }
            case SERVICE_REMOVED: {
                this.onServiceRemoved(event);
                break;
            }
            case SERVICE_STARTED: {
                this.onServiceStarted(event);
                break;
            }
            case SERVICE_STOPPING: {
                this.onServiceStopping(event);
                break;
            }
            case SERVICE_STOPPED: {
                this.onServiceStopped(event);
                break;
            }
        }
    }

    private void onServiceStopping(ServiceEvent event) {
        ServiceController controller = event.getController();
        this.stoppingServices.add(controller);
        ServiceName<?> groupName = controller.getGroupName();
        if (groupName != null) {
            ServiceGroup serviceGroup = this.getOrCreateGroup(groupName);
            serviceGroup.removeService(controller);
        }
        Map<ServiceName<?>, ServiceGroupReference<?>> injectedReferences = controller.getInjectedReferences();
        injectedReferences.entrySet().forEach(e -> {
            ServiceName refGroupName = (ServiceName)e.getKey();
            ServiceGroupReference reference = (ServiceGroupReference)e.getValue();
            ServiceGroup refGroup = this.getOrCreateGroup(refGroupName);
            refGroup.removeReference(reference);
        });
        List<ServiceController> dependents = this.dependentServices.get((Object)controller);
        for (ServiceController dependentService : dependents) {
            dependentService.getChannel().add((Object)new ServiceEvent(ServiceEvent.ServiceEventType.DEPENDENCIES_UNAVAILABLE, dependentService));
        }
        if (dependents.isEmpty()) {
            controller.getChannel().add((Object)new ServiceEvent(ServiceEvent.ServiceEventType.DEPENDENTS_STOPPED, controller));
        }
    }

    private void onServiceStopped(ServiceEvent event) {
        ServiceController controller = event.getController();
        this.startedServices.remove((Object)controller);
        this.stoppingServices.remove((Object)controller);
    }

    private void onServiceRemoved(ServiceEvent event) {
        ServiceController controller = event.getController();
        List<ServiceController> dependencies = this.resolvedDependencies.remove((Object)controller);
        for (ServiceController dependency : dependencies) {
            List<ServiceController> deps = this.dependentServices.get((Object)dependency);
            if (deps == null) continue;
            if (this.stoppingServices.contains((Object)dependency)) {
                boolean allStopped = true;
                for (int i = 0; i < deps.size() && allStopped; allStopped &= !this.startedServices.contains((Object)deps.get(i)), ++i) {
                }
                if (allStopped) {
                    dependency.getChannel().add((Object)new ServiceEvent(ServiceEvent.ServiceEventType.DEPENDENTS_STOPPED, dependency));
                }
            }
            deps.remove((Object)controller);
        }
        this.installedServices.remove(controller.getServiceName());
        this.dependentServices.remove((Object)controller);
    }

    private void onServiceStarted(ServiceEvent event) {
        ServiceController controller = event.getController();
        this.startedServices.add(controller);
        List<ServiceController> dependentServices = this.dependentServices.get((Object)controller);
        for (ServiceController dependentService : dependentServices) {
            this.checkDependenciesAvailable(dependentService);
        }
        ServiceName<?> groupName = controller.getGroupName();
        if (groupName != null) {
            ServiceGroup serviceGroup = this.getOrCreateGroup(groupName);
            serviceGroup.addService(controller);
        }
        Map<ServiceName<?>, ServiceGroupReference<?>> injectedReferences = controller.getInjectedReferences();
        injectedReferences.entrySet().forEach(e -> {
            ServiceName refGroupName = (ServiceName)e.getKey();
            ServiceGroupReference reference = (ServiceGroupReference)e.getValue();
            ServiceGroup refGroup = this.getOrCreateGroup(refGroupName);
            refGroup.addReference(new ServiceGroupReferenceImpl(controller, reference, refGroup));
        });
    }

    private ServiceGroup getOrCreateGroup(ServiceName<?> groupName) {
        ServiceGroup serviceGroup = this.groups.get(groupName);
        if (serviceGroup == null) {
            serviceGroup = new ServiceGroup(groupName);
            this.groups.put(groupName, serviceGroup);
        }
        return serviceGroup;
    }

    private void onServiceInstalled(ServiceEvent event) {
        ServiceController controller = event.getController();
        this.installedServices.put(controller.getServiceName(), controller);
        Set<ServiceName<?>> dependencies = controller.getDependencies();
        ArrayList<ServiceController> resolvedDependencies = new ArrayList<ServiceController>();
        for (ServiceName<?> serviceName : dependencies) {
            ServiceController resolvedController = this.installedServices.get(serviceName);
            if (resolvedController != null) {
                resolvedDependencies.add(resolvedController);
                this.dependentServices.get((Object)resolvedController).add(controller);
                continue;
            }
            List<ServiceController> list = this.unresolvedDependencies.get(serviceName);
            if (list == null) {
                list = new ArrayList<ServiceController>();
                this.unresolvedDependencies.put(serviceName, list);
            }
            list.add(controller);
        }
        this.resolvedDependencies.put(controller, resolvedDependencies);
        List<ServiceController> dependents = this.unresolvedDependencies.remove(controller.getServiceName());
        if (dependents != null) {
            for (ServiceController dependent : dependents) {
                this.resolvedDependencies.get((Object)dependent).add(controller);
            }
        } else {
            dependents = new ArrayList<ServiceController>();
        }
        this.dependentServices.put(controller, dependents);
        this.checkDependenciesAvailable(controller);
    }

    private void checkDependenciesAvailable(ServiceController controller) {
        Set<ServiceName<?>> dependencies = controller.getDependencies();
        List<ServiceController> resolvedDependencies = this.resolvedDependencies.get((Object)controller);
        boolean dependenciesAvailable = true;
        if (resolvedDependencies.size() == dependencies.size()) {
            for (int i = 0; i < resolvedDependencies.size() && dependenciesAvailable; dependenciesAvailable &= !this.stoppingServices.contains((Object)resolvedDependencies.get(i)), ++i) {
                dependenciesAvailable &= this.startedServices.contains((Object)resolvedDependencies.get(i));
            }
        } else {
            dependenciesAvailable = false;
        }
        if (dependenciesAvailable) {
            controller.getChannel().add((Object)new ServiceEvent(ServiceEvent.ServiceEventType.DEPENDENCIES_AVAILABLE, controller, new ArrayList<ServiceController>(resolvedDependencies)));
        }
    }

    final ServiceController getService(ServiceName<?> name) {
        return this.installedServices.get(name);
    }

    public Collection<ServiceController> getControllers() {
        return this.installedServices.values();
    }
}

