/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.servicecontainer.impl;

import io.zeebe.servicecontainer.impl.ServiceController;

public class ServiceEvent {
    private final ServiceEventType type;
    private final ServiceController controller;
    private final Object payload;

    public ServiceEvent(ServiceEventType type, ServiceController controller, Object payload) {
        this.type = type;
        this.controller = controller;
        this.payload = payload;
    }

    public ServiceEvent(ServiceEventType type, ServiceController controller) {
        this(type, controller, null);
    }

    public ServiceEventType getType() {
        return this.type;
    }

    public ServiceController getController() {
        return this.controller;
    }

    public Object getPayload() {
        return this.payload;
    }

    public String toString() {
        return String.format("%s - %s", new Object[]{this.controller, this.type});
    }

    public static enum ServiceEventType {
        SERVICE_INSTALLED,
        SERVICE_START_FAILED,
        SERVICE_STARTED,
        SERVICE_STOPPING,
        SERVICE_STOPPED,
        SERVICE_REMOVED,
        DEPENDENCIES_AVAILABLE,
        DEPENDENCIES_UNAVAILABLE,
        DEPENDENTS_STOPPED;

    }
}

