/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.servicecontainer.impl;

import io.zeebe.servicecontainer.ServiceGroupReference;
import io.zeebe.servicecontainer.ServiceName;
import io.zeebe.servicecontainer.impl.ServiceController;
import io.zeebe.servicecontainer.impl.ServiceGroup;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class ServiceGroupReferenceImpl {
    protected final ServiceController referringService;
    protected final ServiceGroupReference injector;
    protected final ServiceGroup group;
    protected final Map<ServiceName, Object> injectedValues = new HashMap<ServiceName, Object>();

    public ServiceGroupReferenceImpl(ServiceController referringService, ServiceGroupReference injector, ServiceGroup group) {
        this.referringService = referringService;
        this.injector = injector;
        this.group = group;
    }

    public ServiceController getReferringService() {
        return this.referringService;
    }

    public ServiceGroupReference getInjector() {
        return this.injector;
    }

    public ServiceGroup getGroup() {
        return this.group;
    }

    public void addValue(ServiceName name, Object value) {
        this.referringService.addReferencedValue(this.injector, name, value);
        this.injectedValues.put(name, value);
    }

    public void removeValue(ServiceName name, Object value) {
        if (this.injectedValues.containsKey(name)) {
            this.referringService.removeReferencedValue(this.injector, name, value);
            this.injectedValues.remove(name);
        }
    }

    public void uninject() {
        Set<Map.Entry<ServiceName, Object>> entries = this.injectedValues.entrySet();
        for (Map.Entry<ServiceName, Object> e : entries) {
            if (!this.injectedValues.containsKey(e.getKey())) continue;
            this.referringService.removeReferencedValue(this.injector, e.getKey(), e.getValue());
        }
        this.injectedValues.clear();
    }
}

