/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.raft.roles;

import io.atomix.protocols.raft.RaftServer;
import io.atomix.protocols.raft.cluster.impl.DefaultRaftMember;
import io.atomix.protocols.raft.cluster.impl.RaftMemberContext;
import io.atomix.protocols.raft.impl.RaftContext;
import io.atomix.protocols.raft.protocol.AppendRequest;
import io.atomix.protocols.raft.protocol.AppendResponse;
import io.atomix.protocols.raft.protocol.RaftResponse;
import io.atomix.protocols.raft.protocol.VoteRequest;
import io.atomix.protocols.raft.protocol.VoteResponse;
import io.atomix.protocols.raft.roles.ActiveRole;
import io.atomix.protocols.raft.roles.RaftRole;
import io.atomix.protocols.raft.storage.log.entry.RaftLogEntry;
import io.atomix.protocols.raft.utils.Quorum;
import io.atomix.storage.journal.Indexed;
import io.atomix.utils.concurrent.Scheduled;
import java.time.Duration;
import java.util.HashSet;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;

public final class CandidateRole
extends ActiveRole {
    private final Random random = new Random();
    private Scheduled currentTimer;

    public CandidateRole(RaftContext context) {
        super(context);
    }

    @Override
    public RaftServer.Role role() {
        return RaftServer.Role.CANDIDATE;
    }

    @Override
    public synchronized CompletableFuture<RaftRole> start() {
        if (this.raft.getCluster().getActiveMemberStates().isEmpty()) {
            this.log.debug("Single member cluster. Transitioning directly to leader.");
            this.raft.setTerm(this.raft.getTerm() + 1L);
            this.raft.setLastVotedFor(this.raft.getCluster().getMember().memberId());
            this.raft.transition(RaftServer.Role.LEADER);
            return CompletableFuture.completedFuture(this);
        }
        return ((CompletableFuture)super.start().thenRun(this::startElection)).thenApply(v -> this);
    }

    void startElection() {
        this.log.info("Starting election");
        this.sendVoteRequests();
    }

    private void sendVoteRequests() {
        this.raft.checkThread();
        if (!this.isRunning()) {
            return;
        }
        if (this.currentTimer != null) {
            this.currentTimer.cancel();
        }
        this.raft.setTerm(this.raft.getTerm() + 1L);
        this.raft.setLastVotedFor(this.raft.getCluster().getMember().memberId());
        AtomicBoolean complete = new AtomicBoolean();
        HashSet votingMembers = new HashSet(this.raft.getCluster().getActiveMemberStates().stream().map(RaftMemberContext::getMember).collect(Collectors.toList()));
        Quorum quorum = new Quorum(this.raft.getCluster().getQuorum(), elected -> {
            if (!this.isRunning()) {
                return;
            }
            complete.set(true);
            if (elected.booleanValue()) {
                this.raft.transition(RaftServer.Role.LEADER);
            } else {
                this.raft.transition(RaftServer.Role.FOLLOWER);
            }
        });
        Duration delay = this.raft.getElectionTimeout().plus(Duration.ofMillis(this.random.nextInt((int)this.raft.getElectionTimeout().toMillis())));
        this.currentTimer = this.raft.getThreadContext().schedule(delay, () -> {
            if (!complete.get()) {
                this.log.debug("Election timed out");
                quorum.cancel();
                this.sendVoteRequests();
                this.log.debug("Restarted election");
            }
        });
        Indexed lastEntry = this.raft.getLogWriter().getLastEntry();
        long lastTerm = lastEntry != null ? ((RaftLogEntry)lastEntry.entry()).term() : 0L;
        this.log.debug("Requesting votes for term {}", (Object)this.raft.getTerm());
        for (DefaultRaftMember member : votingMembers) {
            this.log.debug("Requesting vote from {} for term {}", (Object)member, (Object)this.raft.getTerm());
            VoteRequest request = VoteRequest.builder().withTerm(this.raft.getTerm()).withCandidate(this.raft.getCluster().getMember().memberId()).withLastLogIndex(lastEntry != null ? lastEntry.index() : 0L).withLastLogTerm(lastTerm).build();
            this.raft.getProtocol().vote(member.memberId(), request).whenCompleteAsync((response, error) -> {
                this.raft.checkThread();
                if (this.isRunning() && !complete.get()) {
                    if (error != null) {
                        this.log.warn(error.getMessage());
                        quorum.fail();
                    } else if (response.term() > this.raft.getTerm()) {
                        this.log.debug("Received greater term from {}", (Object)member);
                        this.raft.setTerm(response.term());
                        complete.set(true);
                        this.raft.transition(RaftServer.Role.FOLLOWER);
                    } else if (!response.voted()) {
                        this.log.debug("Received rejected vote from {}", (Object)member);
                        quorum.fail();
                    } else if (response.term() != this.raft.getTerm()) {
                        this.log.debug("Received successful vote for a different term from {}", (Object)member);
                        quorum.fail();
                    } else {
                        this.log.debug("Received successful vote from {}", (Object)member);
                        quorum.succeed();
                    }
                }
            }, (Executor)this.raft.getThreadContext());
        }
    }

    @Override
    public CompletableFuture<AppendResponse> onAppend(AppendRequest request) {
        this.raft.checkThread();
        if (request.term() >= this.raft.getTerm()) {
            this.raft.setTerm(request.term());
            this.raft.transition(RaftServer.Role.FOLLOWER);
        }
        return super.onAppend(request);
    }

    @Override
    public CompletableFuture<VoteResponse> onVote(VoteRequest request) {
        this.raft.checkThread();
        this.logRequest(request);
        if (this.updateTermAndLeader(request.term(), null)) {
            CompletableFuture<VoteResponse> future = super.onVote(request);
            this.raft.transition(RaftServer.Role.FOLLOWER);
            return future;
        }
        if (request.candidate() == this.raft.getCluster().getMember().memberId()) {
            return CompletableFuture.completedFuture(this.logResponse(((VoteResponse.Builder)VoteResponse.builder().withStatus(RaftResponse.Status.OK)).withTerm(this.raft.getTerm()).withVoted(true).build()));
        }
        return CompletableFuture.completedFuture(this.logResponse(((VoteResponse.Builder)VoteResponse.builder().withStatus(RaftResponse.Status.OK)).withTerm(this.raft.getTerm()).withVoted(false).build()));
    }

    private void cancelElection() {
        this.raft.checkThread();
        if (this.currentTimer != null) {
            this.log.debug("Cancelling election");
            this.currentTimer.cancel();
        }
    }

    @Override
    public synchronized CompletableFuture<Void> stop() {
        return super.stop().thenRun(this::cancelElection);
    }
}

