/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.broker;

import io.zeebe.broker.Loggers;
import io.zeebe.broker.clustering.ClusterComponent;
import io.zeebe.broker.engine.EngineComponent;
import io.zeebe.broker.exporter.ExporterComponent;
import io.zeebe.broker.system.SystemComponent;
import io.zeebe.broker.system.SystemContext;
import io.zeebe.broker.system.configuration.BrokerCfg;
import io.zeebe.broker.transport.TransportComponent;
import io.zeebe.util.LogUtil;
import io.zeebe.util.sched.clock.ActorClock;
import java.io.InputStream;
import org.slf4j.Logger;

public class Broker
implements AutoCloseable {
    public static final Logger LOG = Loggers.SYSTEM_LOGGER;
    public static final String VERSION;
    protected final SystemContext brokerContext;
    protected boolean isClosed = false;

    public Broker(String configFileLocation, String basePath, ActorClock clock) {
        this(new SystemContext(configFileLocation, basePath, clock));
    }

    public Broker(InputStream configStream, String basePath, ActorClock clock) {
        this(new SystemContext(configStream, basePath, clock));
    }

    public Broker(BrokerCfg cfg, String basePath, ActorClock clock) {
        this(new SystemContext(cfg, basePath, clock));
    }

    public Broker(SystemContext systemContext) {
        this.brokerContext = systemContext;
        LogUtil.doWithMDC(systemContext.getDiagnosticContext(), () -> this.start());
    }

    protected void start() {
        LOG.info("Version: {}", (Object)VERSION);
        LOG.info("Starting broker with configuration {}", (Object)this.getConfig().toJson());
        this.brokerContext.addComponent(new SystemComponent());
        this.brokerContext.addComponent(new TransportComponent());
        this.brokerContext.addComponent(new EngineComponent());
        this.brokerContext.addComponent(new ClusterComponent());
        this.brokerContext.addComponent(new ExporterComponent());
        this.brokerContext.init();
    }

    @Override
    public void close() {
        LogUtil.doWithMDC(this.brokerContext.getDiagnosticContext(), () -> {
            if (!this.isClosed) {
                this.brokerContext.close();
                this.isClosed = true;
                LOG.info("Broker closed");
            }
        });
    }

    public SystemContext getBrokerContext() {
        return this.brokerContext;
    }

    public BrokerCfg getConfig() {
        return this.brokerContext.getBrokerConfiguration();
    }

    static {
        String version = Broker.class.getPackage().getImplementationVersion();
        VERSION = version != null ? version : "development";
    }
}

