/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.broker.clustering;

import io.zeebe.broker.clustering.base.ClusterBaseLayerServiceNames;
import io.zeebe.broker.clustering.base.EmbeddedGatewayService;
import io.zeebe.broker.clustering.base.gossip.AtomixJoinService;
import io.zeebe.broker.clustering.base.gossip.AtomixService;
import io.zeebe.broker.clustering.base.gossip.DistributedLogService;
import io.zeebe.broker.clustering.base.partitions.BootstrapPartitions;
import io.zeebe.broker.clustering.base.raft.RaftPersistentConfigurationManagerService;
import io.zeebe.broker.clustering.base.topology.NodeInfo;
import io.zeebe.broker.clustering.base.topology.TopologyManagerService;
import io.zeebe.broker.system.Component;
import io.zeebe.broker.system.SystemContext;
import io.zeebe.broker.system.configuration.BrokerCfg;
import io.zeebe.broker.system.configuration.NetworkCfg;
import io.zeebe.distributedlog.impl.LogstreamConfig;
import io.zeebe.servicecontainer.CompositeServiceBuilder;
import io.zeebe.servicecontainer.Service;
import io.zeebe.servicecontainer.ServiceContainer;

public class ClusterComponent
implements Component {
    @Override
    public void init(SystemContext context) {
        ServiceContainer serviceContainer = context.getServiceContainer();
        this.initClusterBaseLayer(context, serviceContainer);
    }

    private void initClusterBaseLayer(SystemContext context, ServiceContainer serviceContainer) {
        BrokerCfg brokerConfig = context.getBrokerConfiguration();
        NetworkCfg networkCfg = brokerConfig.getNetwork();
        CompositeServiceBuilder baseLayerInstall = serviceContainer.createComposite(ClusterBaseLayerServiceNames.CLUSTERING_BASE_LAYER);
        NodeInfo localMember = new NodeInfo(brokerConfig.getCluster().getNodeId(), networkCfg.getCommandApi().toSocketAddress());
        LogstreamConfig.putServiceContainer((String)String.valueOf(localMember.getNodeId()), (ServiceContainer)context.getServiceContainer());
        TopologyManagerService topologyManagerService = new TopologyManagerService(localMember, brokerConfig.getCluster());
        baseLayerInstall.createService(ClusterBaseLayerServiceNames.TOPOLOGY_MANAGER_SERVICE, (Service)topologyManagerService).dependency(ClusterBaseLayerServiceNames.ATOMIX_SERVICE, topologyManagerService.getAtomixInjector()).groupReference(ClusterBaseLayerServiceNames.LEADER_PARTITION_GROUP_NAME, topologyManagerService.getLeaderInstallReference()).groupReference(ClusterBaseLayerServiceNames.FOLLOWER_PARTITION_GROUP_NAME, topologyManagerService.getFollowerInstallReference()).install();
        if (brokerConfig.getGateway().isEnable()) {
            this.initGateway(baseLayerInstall, brokerConfig);
        }
        this.initAtomix(baseLayerInstall, context);
        this.initPartitions(baseLayerInstall, context);
        context.addRequiredStartAction(baseLayerInstall.install());
    }

    private void initGateway(CompositeServiceBuilder baseLayerInstall, BrokerCfg brokerConfig) {
        EmbeddedGatewayService gatewayService = new EmbeddedGatewayService(brokerConfig);
        baseLayerInstall.createService(ClusterBaseLayerServiceNames.GATEWAY_SERVICE, (Service)gatewayService).dependency(ClusterBaseLayerServiceNames.ATOMIX_SERVICE, gatewayService.getAtomixClusterInjector()).install();
    }

    private void initAtomix(CompositeServiceBuilder baseLayerInstall, SystemContext context) {
        AtomixService atomixService = new AtomixService(context.getBrokerConfiguration());
        baseLayerInstall.createService(ClusterBaseLayerServiceNames.ATOMIX_SERVICE, (Service)atomixService).dependency(ClusterBaseLayerServiceNames.RAFT_CONFIGURATION_MANAGER).install();
        AtomixJoinService atomixJoinService = new AtomixJoinService();
        context.getServiceContainer().createService(ClusterBaseLayerServiceNames.ATOMIX_JOIN_SERVICE, (Service)atomixJoinService).dependency(ClusterBaseLayerServiceNames.TOPOLOGY_MANAGER_SERVICE).dependency(ClusterBaseLayerServiceNames.ATOMIX_SERVICE, atomixJoinService.getAtomixInjector()).install();
        DistributedLogService distributedLogService = new DistributedLogService();
        context.getServiceContainer().createService(ClusterBaseLayerServiceNames.DISTRIBUTED_LOG_CREATE_SERVICE, (Service)distributedLogService).dependency(ClusterBaseLayerServiceNames.ATOMIX_SERVICE, distributedLogService.getAtomixInjector()).dependency(ClusterBaseLayerServiceNames.ATOMIX_JOIN_SERVICE).install();
    }

    private void initPartitions(CompositeServiceBuilder baseLayerInstall, SystemContext context) {
        RaftPersistentConfigurationManagerService raftConfigurationManagerService = new RaftPersistentConfigurationManagerService(context.getBrokerConfiguration());
        baseLayerInstall.createService(ClusterBaseLayerServiceNames.RAFT_CONFIGURATION_MANAGER, (Service)raftConfigurationManagerService).install();
        BootstrapPartitions partitionBootstrapService = new BootstrapPartitions(context.getBrokerConfiguration());
        context.getServiceContainer().createService(ClusterBaseLayerServiceNames.PARTITIONS_BOOTSTRAP_SERVICE, (Service)partitionBootstrapService).dependency(ClusterBaseLayerServiceNames.ATOMIX_SERVICE, partitionBootstrapService.getAtomixInjector()).dependency(ClusterBaseLayerServiceNames.ATOMIX_JOIN_SERVICE).dependency(ClusterBaseLayerServiceNames.RAFT_CONFIGURATION_MANAGER, partitionBootstrapService.getConfigurationManagerInjector()).install();
    }
}

