/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.broker.clustering.base;

import io.atomix.cluster.AtomixCluster;
import io.zeebe.broker.system.configuration.BrokerCfg;
import io.zeebe.gateway.Gateway;
import io.zeebe.gateway.impl.broker.BrokerClient;
import io.zeebe.gateway.impl.broker.BrokerClientImpl;
import io.zeebe.gateway.impl.configuration.GatewayCfg;
import io.zeebe.servicecontainer.Injector;
import io.zeebe.servicecontainer.Service;
import io.zeebe.servicecontainer.ServiceStartContext;
import io.zeebe.servicecontainer.ServiceStopContext;
import java.io.IOException;
import java.util.function.Function;

public class EmbeddedGatewayService
implements Service<Gateway> {
    private final BrokerCfg configuration;
    private final Injector<AtomixCluster> atomixClusterInjector = new Injector();
    private Gateway gateway;

    public EmbeddedGatewayService(BrokerCfg configuration) {
        this.configuration = configuration;
    }

    public void start(ServiceStartContext startContext) {
        AtomixCluster atomix = (AtomixCluster)this.atomixClusterInjector.getValue();
        Function<GatewayCfg, BrokerClient> brokerClientFactory = cfg -> new BrokerClientImpl(cfg, atomix, startContext.getScheduler(), false);
        this.gateway = new Gateway((GatewayCfg)this.configuration.getGateway(), brokerClientFactory);
        startContext.run(this::startGateway);
    }

    public void stop(ServiceStopContext stopContext) {
        if (this.gateway != null) {
            stopContext.run(() -> ((Gateway)this.gateway).stop());
        }
    }

    private void startGateway() {
        try {
            this.gateway.start();
        }
        catch (IOException e) {
            throw new RuntimeException("Gateway was not able to start", e);
        }
    }

    public Gateway get() {
        return this.gateway;
    }

    public Injector<AtomixCluster> getAtomixClusterInjector() {
        return this.atomixClusterInjector;
    }
}

