/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.broker.clustering.base.gossip;

import io.atomix.cluster.Node;
import io.atomix.cluster.discovery.BootstrapDiscoveryBuilder;
import io.atomix.cluster.discovery.BootstrapDiscoveryProvider;
import io.atomix.cluster.discovery.NodeDiscoveryProvider;
import io.atomix.core.Atomix;
import io.atomix.core.AtomixBuilder;
import io.atomix.primitive.partition.ManagedPartitionGroup;
import io.atomix.protocols.raft.partition.RaftPartitionGroup;
import io.atomix.utils.net.Address;
import io.zeebe.broker.Loggers;
import io.zeebe.broker.logstreams.restore.BrokerRestoreFactory;
import io.zeebe.broker.system.configuration.BrokerCfg;
import io.zeebe.broker.system.configuration.ClusterCfg;
import io.zeebe.broker.system.configuration.DataCfg;
import io.zeebe.broker.system.configuration.NetworkCfg;
import io.zeebe.distributedlog.impl.LogstreamConfig;
import io.zeebe.distributedlog.restore.RestoreFactory;
import io.zeebe.servicecontainer.Service;
import io.zeebe.servicecontainer.ServiceStartContext;
import io.zeebe.servicecontainer.ServiceStopContext;
import io.zeebe.util.ByteValue;
import io.zeebe.util.sched.future.ActorFuture;
import io.zeebe.util.sched.future.CompletableActorFuture;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;

public class AtomixService
implements Service<Atomix> {
    private static final Logger LOG = Loggers.CLUSTERING_LOGGER;
    private final BrokerCfg configuration;
    private Atomix atomix;

    public AtomixService(BrokerCfg configuration) {
        this.configuration = configuration;
    }

    public void start(ServiceStartContext startContext) {
        ClusterCfg clusterCfg = this.configuration.getCluster();
        int nodeId = clusterCfg.getNodeId();
        String localMemberId = Integer.toString(nodeId);
        NetworkCfg networkCfg = this.configuration.getNetwork();
        String host = networkCfg.getInternalApi().getHost();
        int port = networkCfg.getInternalApi().getPort();
        NodeDiscoveryProvider discoveryProvider = this.createDiscoveryProvider(clusterCfg, localMemberId);
        LOG.debug("Setup atomix node in cluster {}", (Object)clusterCfg.getClusterName());
        AtomixBuilder atomixBuilder = Atomix.builder().withClusterId(clusterCfg.getClusterName()).withMemberId(localMemberId).withAddress(Address.from((String)host, (int)port)).withMembershipProvider(discoveryProvider);
        DataCfg dataConfiguration = this.configuration.getData();
        String rootDirectory = dataConfiguration.getDirectories().get(0);
        String systemPartitionName = "system";
        File systemDirectory = new File(rootDirectory, "system");
        if (!systemDirectory.exists()) {
            try {
                Files.createDirectory(systemDirectory.toPath(), new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to create directory " + systemDirectory, e);
            }
        }
        RaftPartitionGroup systemGroup = RaftPartitionGroup.builder((String)"system").withNumPartitions(1).withPartitionSize(this.configuration.getCluster().getClusterSize()).withMembers(this.getRaftGroupMembers(clusterCfg)).withDataDirectory(systemDirectory).withFlushOnCommit().build();
        String raftPartitionGroupName = "raft-atomix";
        File raftDirectory = new File(rootDirectory, "raft-atomix");
        if (!raftDirectory.exists()) {
            try {
                Files.createDirectory(raftDirectory.toPath(), new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to create directory " + raftDirectory, e);
            }
        }
        RaftPartitionGroup.Builder partitionGroupBuilder = RaftPartitionGroup.builder((String)"raft-atomix").withNumPartitions(this.configuration.getCluster().getPartitionsCount()).withPartitionSize(this.configuration.getCluster().getReplicationFactor()).withMembers(this.getRaftGroupMembers(clusterCfg)).withDataDirectory(raftDirectory).withFlushOnCommit();
        if (dataConfiguration.getRaftSegmentSize() != null) {
            partitionGroupBuilder.withSegmentSize(new ByteValue(dataConfiguration.getRaftSegmentSize()).toBytes());
        }
        RaftPartitionGroup partitionGroup = partitionGroupBuilder.build();
        atomixBuilder.withManagementGroup((ManagedPartitionGroup)systemGroup).withPartitionGroups(new ManagedPartitionGroup[]{partitionGroup});
        this.atomix = atomixBuilder.build();
        BrokerRestoreFactory restoreFactory = new BrokerRestoreFactory(this.atomix.getCommunicationService(), this.atomix.getPartitionService(), "raft-atomix", localMemberId);
        LogstreamConfig.putRestoreFactory((String)localMemberId, (RestoreFactory)restoreFactory);
    }

    public void stop(ServiceStopContext stopContext) {
        String localMemberId = (String)((Object)this.atomix.getMembershipService().getLocalMember().id().id());
        CompletableFuture stopFuture = this.atomix.stop();
        stopContext.async(this.mapCompletableFuture(stopFuture));
        LogstreamConfig.removeRestoreFactory((String)localMemberId);
    }

    public Atomix get() {
        return this.atomix;
    }

    private List<String> getRaftGroupMembers(ClusterCfg clusterCfg) {
        int clusterSize = clusterCfg.getClusterSize();
        ArrayList<String> members = new ArrayList<String>();
        for (int i = 0; i < clusterSize; ++i) {
            members.add(Integer.toString(i));
        }
        return members;
    }

    private NodeDiscoveryProvider createDiscoveryProvider(ClusterCfg clusterCfg, String localMemberId) {
        BootstrapDiscoveryBuilder builder = BootstrapDiscoveryProvider.builder();
        List<String> initialContactPoints = clusterCfg.getInitialContactPoints();
        ArrayList nodes = new ArrayList();
        initialContactPoints.forEach(contactAddress -> {
            String[] address = contactAddress.split(":");
            int memberPort = Integer.parseInt(address[1]);
            Node node = Node.builder().withAddress(Address.from((String)address[0], (int)memberPort)).build();
            LOG.debug("Member {} will contact node: {}", (Object)localMemberId, (Object)node.address());
            nodes.add(node);
        });
        return builder.withNodes(nodes).build();
    }

    private ActorFuture<Void> mapCompletableFuture(CompletableFuture<Void> atomixFuture) {
        CompletableActorFuture mappedActorFuture = new CompletableActorFuture();
        ((CompletableFuture)atomixFuture.thenAccept(arg_0 -> ((ActorFuture)mappedActorFuture).complete(arg_0))).exceptionally(arg_0 -> AtomixService.lambda$mapCompletableFuture$1((ActorFuture)mappedActorFuture, arg_0));
        return mappedActorFuture;
    }

    private static /* synthetic */ Void lambda$mapCompletableFuture$1(ActorFuture mappedActorFuture, Throwable t) {
        mappedActorFuture.completeExceptionally(t);
        return null;
    }
}

