/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.broker.clustering.base.partitions;

import io.atomix.cluster.MemberId;
import io.atomix.core.Atomix;
import io.atomix.protocols.raft.partition.RaftPartition;
import io.atomix.protocols.raft.partition.RaftPartitionGroup;
import io.zeebe.broker.clustering.base.partitions.Partition;
import io.zeebe.broker.clustering.base.partitions.PartitionInstallService;
import io.zeebe.broker.clustering.base.partitions.PartitionServiceNames;
import io.zeebe.broker.system.configuration.BrokerCfg;
import io.zeebe.distributedlog.StorageConfiguration;
import io.zeebe.distributedlog.StorageConfigurationManager;
import io.zeebe.servicecontainer.Injector;
import io.zeebe.servicecontainer.Service;
import io.zeebe.servicecontainer.ServiceName;
import io.zeebe.servicecontainer.ServiceStartContext;
import java.util.List;
import java.util.stream.Collectors;

public class BootstrapPartitions
implements Service<Void> {
    private final Injector<StorageConfigurationManager> configurationManagerInjector = new Injector();
    private final BrokerCfg brokerCfg;
    private StorageConfigurationManager configurationManager;
    private ServiceStartContext startContext;
    private final Injector<Atomix> atomixInjector = new Injector();
    private Atomix atomix;

    public BootstrapPartitions(BrokerCfg brokerCfg) {
        this.brokerCfg = brokerCfg;
    }

    public void start(ServiceStartContext startContext) {
        this.configurationManager = (StorageConfigurationManager)this.configurationManagerInjector.getValue();
        this.atomix = (Atomix)this.atomixInjector.getValue();
        RaftPartitionGroup partitionGroup = (RaftPartitionGroup)this.atomix.getPartitionService().getPartitionGroup("raft-atomix");
        MemberId nodeId = this.atomix.getMembershipService().getLocalMember().id();
        List owningPartitions = partitionGroup.getPartitions().stream().filter(partition -> partition.members().contains(nodeId)).map(RaftPartition.class::cast).collect(Collectors.toList());
        this.startContext = startContext;
        startContext.run(() -> {
            for (RaftPartition owningPartition : owningPartitions) {
                this.installPartition(owningPartition);
            }
        });
    }

    private void installPartition(RaftPartition partition) {
        StorageConfiguration configuration = (StorageConfiguration)this.configurationManager.createConfiguration(((Integer)partition.id().id()).intValue()).join();
        this.installPartition(this.startContext, configuration, partition);
    }

    private void installPartition(ServiceStartContext startContext, StorageConfiguration configuration, RaftPartition partition) {
        String partitionName = Partition.getPartitionName(configuration.getPartitionId());
        ServiceName<Void> partitionInstallServiceName = PartitionServiceNames.partitionInstallServiceName(partitionName);
        String localMemberId = (String)((Object)this.atomix.getMembershipService().getLocalMember().id().id());
        PartitionInstallService partitionInstallService = new PartitionInstallService(partition, this.atomix.getEventService(), this.atomix.getCommunicationService(), configuration, this.brokerCfg);
        startContext.createService(partitionInstallServiceName, (Service)partitionInstallService).install();
    }

    public Void get() {
        return null;
    }

    public Injector<StorageConfigurationManager> getConfigurationManagerInjector() {
        return this.configurationManagerInjector;
    }

    public Injector<Atomix> getAtomixInjector() {
        return this.atomixInjector;
    }
}

