/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.broker.clustering.base.partitions;

import io.atomix.cluster.messaging.ClusterEventService;
import io.zeebe.broker.Loggers;
import io.zeebe.broker.clustering.base.partitions.RaftState;
import io.zeebe.broker.engine.EngineServiceNames;
import io.zeebe.broker.engine.impl.StateReplication;
import io.zeebe.broker.exporter.ExporterServiceNames;
import io.zeebe.broker.logstreams.delete.FollowerLogStreamDeletionService;
import io.zeebe.broker.logstreams.delete.LeaderLogStreamDeletionService;
import io.zeebe.broker.logstreams.restore.BrokerRestoreServer;
import io.zeebe.broker.logstreams.state.StatePositionSupplier;
import io.zeebe.broker.system.configuration.BrokerCfg;
import io.zeebe.db.ZeebeDb;
import io.zeebe.distributedlog.StorageConfiguration;
import io.zeebe.engine.state.DefaultZeebeDbFactory;
import io.zeebe.engine.state.StateStorageFactory;
import io.zeebe.logstreams.impl.delete.DeletionService;
import io.zeebe.logstreams.log.LogStream;
import io.zeebe.logstreams.spi.SnapshotController;
import io.zeebe.logstreams.state.NoneSnapshotReplication;
import io.zeebe.logstreams.state.SnapshotReplication;
import io.zeebe.logstreams.state.StateSnapshotController;
import io.zeebe.logstreams.state.StateStorage;
import io.zeebe.servicecontainer.Injector;
import io.zeebe.servicecontainer.Service;
import io.zeebe.servicecontainer.ServiceStartContext;
import io.zeebe.servicecontainer.ServiceStopContext;
import io.zeebe.util.sched.future.ActorFuture;
import io.zeebe.util.sched.future.CompletableActorFuture;
import org.slf4j.Logger;

public class Partition
implements Service<Partition> {
    private static final String PARTITION_NAME_FORMAT = "raft-atomix-partition-%d";
    public static final Logger LOG = Loggers.CLUSTERING_LOGGER;
    private final Injector<LogStream> logStreamInjector = new Injector();
    private final ClusterEventService clusterEventService;
    private final int partitionId;
    private final RaftState state;
    private final StorageConfiguration configuration;
    private final BrokerCfg brokerCfg;
    private final BrokerRestoreServer restoreServer;
    private StateSnapshotController snapshotController;
    private SnapshotReplication stateReplication;
    private LogStream logStream;
    private ZeebeDb zeebeDb;

    public static String getPartitionName(int partitionId) {
        return String.format(PARTITION_NAME_FORMAT, partitionId);
    }

    public Partition(StorageConfiguration configuration, BrokerCfg brokerCfg, ClusterEventService clusterEventService, int partitionId, RaftState state, BrokerRestoreServer restoreServer) {
        this.configuration = configuration;
        this.brokerCfg = brokerCfg;
        this.clusterEventService = clusterEventService;
        this.partitionId = partitionId;
        this.state = state;
        this.restoreServer = restoreServer;
    }

    public void start(ServiceStartContext startContext) {
        CompletableActorFuture startedFuture = new CompletableActorFuture();
        this.logStream = (LogStream)this.logStreamInjector.getValue();
        this.snapshotController = this.createSnapshotController();
        if (this.state == RaftState.FOLLOWER) {
            StatePositionSupplier positionSupplier = new StatePositionSupplier((SnapshotController)this.snapshotController, this.partitionId, String.valueOf(this.brokerCfg.getCluster().getNodeId()), LOG);
            FollowerLogStreamDeletionService deletionService = new FollowerLogStreamDeletionService(this.logStream, positionSupplier);
            this.snapshotController.setDeletionService((DeletionService)deletionService);
            this.snapshotController.consumeReplicatedSnapshots();
        } else {
            LeaderLogStreamDeletionService leaderDeletionService = new LeaderLogStreamDeletionService(this.logStream);
            startContext.createService(EngineServiceNames.leaderLogStreamDeletionService(this.partitionId), (Service)leaderDeletionService).dependency(ExporterServiceNames.EXPORTER_MANAGER, leaderDeletionService.getExporterManagerInjector()).install();
            LeaderLogStreamDeletionService deletionService = leaderDeletionService;
            this.snapshotController.setDeletionService((DeletionService)deletionService);
            try {
                this.snapshotController.recover();
                this.zeebeDb = this.snapshotController.openDb();
            }
            catch (Exception e) {
                throw new IllegalStateException(String.format("Unexpected error occurred while recovering snapshot controller during leader partition install for partition %d", this.partitionId), e);
            }
        }
        this.startRestoreServer((CompletableActorFuture<Void>)startedFuture);
        startContext.async((ActorFuture)startedFuture, true);
    }

    private void startRestoreServer(CompletableActorFuture<Void> startedFuture) {
        this.restoreServer.start(this.logStream, (SnapshotController)this.snapshotController).whenComplete((nothing, error) -> {
            if (error != null) {
                startedFuture.completeExceptionally(error);
            } else {
                startedFuture.complete(null);
            }
        });
    }

    public StorageConfiguration getConfiguration() {
        return this.configuration;
    }

    private StateSnapshotController createSnapshotController() {
        String streamProcessorName = "zb-stream-processor";
        StateStorageFactory storageFactory = new StateStorageFactory(this.configuration.getStatesDirectory());
        StateStorage stateStorage = storageFactory.create(this.partitionId, "zb-stream-processor");
        this.stateReplication = this.shouldReplicateSnapshots() ? new StateReplication(this.clusterEventService, this.partitionId, "zb-stream-processor") : new NoneSnapshotReplication();
        return new StateSnapshotController(DefaultZeebeDbFactory.DEFAULT_DB_FACTORY, stateStorage, this.stateReplication, this.brokerCfg.getData().getMaxSnapshots());
    }

    private boolean shouldReplicateSnapshots() {
        return this.brokerCfg.getCluster().getReplicationFactor() > 1;
    }

    public void stop(ServiceStopContext stopContext) {
        this.stateReplication.close();
        this.restoreServer.close();
        try {
            this.snapshotController.close();
        }
        catch (Exception e) {
            LOG.error("Unexpected error occurred while closing the state snapshot controller for partition {}.", (Object)this.partitionId, (Object)e);
        }
    }

    public Partition get() {
        return this;
    }

    public int getPartitionId() {
        return this.partitionId;
    }

    public StateSnapshotController getSnapshotController() {
        return this.snapshotController;
    }

    public RaftState getState() {
        return this.state;
    }

    public LogStream getLogStream() {
        return this.logStream;
    }

    public Injector<LogStream> getLogStreamInjector() {
        return this.logStreamInjector;
    }

    public ZeebeDb getZeebeDb() {
        return this.zeebeDb;
    }
}

