/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.broker.clustering.base.partitions;

import io.atomix.cluster.messaging.ClusterCommunicationService;
import io.atomix.cluster.messaging.ClusterEventService;
import io.atomix.protocols.raft.partition.RaftPartition;
import io.zeebe.broker.Loggers;
import io.zeebe.broker.clustering.base.ClusterBaseLayerServiceNames;
import io.zeebe.broker.clustering.base.partitions.Partition;
import io.zeebe.broker.clustering.base.partitions.PartitionLeaderElection;
import io.zeebe.broker.clustering.base.partitions.PartitionRoleChangeListener;
import io.zeebe.broker.clustering.base.partitions.PartitionServiceNames;
import io.zeebe.broker.clustering.base.partitions.RaftState;
import io.zeebe.broker.logstreams.restore.BrokerRestoreServer;
import io.zeebe.broker.system.configuration.BrokerCfg;
import io.zeebe.distributedlog.StorageConfiguration;
import io.zeebe.distributedlog.impl.DistributedLogstreamPartition;
import io.zeebe.logstreams.impl.service.LeaderOpenLogStreamAppenderService;
import io.zeebe.logstreams.impl.service.LogStreamServiceNames;
import io.zeebe.logstreams.log.LogStream;
import io.zeebe.servicecontainer.CompositeServiceBuilder;
import io.zeebe.servicecontainer.Service;
import io.zeebe.servicecontainer.ServiceName;
import io.zeebe.servicecontainer.ServiceStartContext;
import io.zeebe.servicecontainer.ServiceStopContext;
import io.zeebe.util.sched.Actor;
import io.zeebe.util.sched.future.ActorFuture;
import io.zeebe.util.sched.future.CompletableActorFuture;
import org.slf4j.Logger;

public class PartitionInstallService
extends Actor
implements Service<Void>,
PartitionRoleChangeListener {
    private static final Logger LOG = Loggers.CLUSTERING_LOGGER;
    private final StorageConfiguration configuration;
    private final int partitionId;
    private final ClusterEventService clusterEventService;
    private final ClusterCommunicationService communicationService;
    private final BrokerCfg brokerCfg;
    private final RaftPartition partition;
    private ServiceStartContext startContext;
    private ServiceName<LogStream> logStreamServiceName;
    private ServiceName<Void> openLogStreamServiceName;
    private ServiceName<Partition> leaderPartitionServiceName;
    private ServiceName<Partition> followerPartitionServiceName;
    private ServiceName<Void> leaderInstallRootServiceName;
    private String logName;
    private ActorFuture<PartitionLeaderElection> leaderElectionInstallFuture;
    private PartitionLeaderElection leaderElection;
    private ActorFuture<Void> transitionFuture;

    public PartitionInstallService(RaftPartition partition, ClusterEventService clusterEventService, ClusterCommunicationService communicationService, StorageConfiguration configuration, BrokerCfg brokerCfg) {
        this.partition = partition;
        this.configuration = configuration;
        this.partitionId = configuration.getPartitionId();
        this.clusterEventService = clusterEventService;
        this.communicationService = communicationService;
        this.brokerCfg = brokerCfg;
    }

    public Void get() {
        return null;
    }

    public void start(ServiceStartContext startContext) {
        this.startContext = startContext;
        int partitionId = this.configuration.getPartitionId();
        this.logName = Partition.getPartitionName(partitionId);
        ServiceName<Void> raftInstallServiceName = ClusterBaseLayerServiceNames.raftInstallServiceName(partitionId);
        CompositeServiceBuilder partitionInstall = startContext.createComposite(raftInstallServiceName);
        this.logStreamServiceName = LogStreamServiceNames.logStreamServiceName((String)this.logName);
        this.leaderInstallRootServiceName = PartitionServiceNames.leaderInstallServiceRootName(this.logName);
        this.leaderElection = new PartitionLeaderElection(this.partition);
        ServiceName<PartitionLeaderElection> partitionLeaderElectionServiceName = PartitionServiceNames.partitionLeaderElectionServiceName(this.logName);
        this.leaderElectionInstallFuture = partitionInstall.createService(partitionLeaderElectionServiceName, (Service)this.leaderElection).dependency(ClusterBaseLayerServiceNames.ATOMIX_SERVICE, this.leaderElection.getAtomixInjector()).dependency(ClusterBaseLayerServiceNames.ATOMIX_JOIN_SERVICE).group(ClusterBaseLayerServiceNames.LEADERSHIP_SERVICE_GROUP).install();
        partitionInstall.install();
        this.leaderPartitionServiceName = PartitionServiceNames.leaderPartitionServiceName(this.logName);
        this.openLogStreamServiceName = PartitionServiceNames.leaderOpenLogStreamServiceName(this.logName);
        this.followerPartitionServiceName = PartitionServiceNames.followerPartitionServiceName(this.logName);
        startContext.getScheduler().submitActor((Actor)this);
    }

    public void stop(ServiceStopContext stopContext) {
        this.leaderElection.removeListener(this);
    }

    protected void onActorStarted() {
        this.actor.runOnCompletion(this.leaderElectionInstallFuture, (leaderElection, e) -> {
            if (e == null) {
                leaderElection.addListener(this);
            } else {
                LOG.error("Could not install leader election for partition {}", (Object)this.partitionId, e);
            }
        });
    }

    @Override
    public void onTransitionToLeader(int partitionId, long term) {
        this.actor.call(() -> {
            CompletableActorFuture nextTransitionFuture = new CompletableActorFuture();
            if (this.transitionFuture != null && !this.transitionFuture.isDone()) {
                this.actor.runOnCompletion(this.transitionFuture, (r, e) -> this.transitionToLeader((CompletableActorFuture<Void>)nextTransitionFuture, term));
            } else {
                this.transitionToLeader((CompletableActorFuture<Void>)nextTransitionFuture, term);
            }
            this.transitionFuture = nextTransitionFuture;
        });
    }

    private void transitionToLeader(CompletableActorFuture<Void> transitionComplete, long term) {
        this.actor.runOnCompletion(this.removeFollowerPartitionService(), (nothing, error) -> this.actor.runOnCompletion(this.installLeaderPartition(term), (v, e) -> transitionComplete.complete(null)));
    }

    @Override
    public void onTransitionToFollower(int partitionId) {
        this.actor.call(() -> {
            CompletableActorFuture nextTransitionFuture = new CompletableActorFuture();
            if (this.transitionFuture != null && !this.transitionFuture.isDone()) {
                this.actor.runOnCompletion(this.transitionFuture, (r, e) -> this.transitionToFollower((CompletableActorFuture<Void>)nextTransitionFuture));
            } else {
                this.transitionToFollower((CompletableActorFuture<Void>)nextTransitionFuture);
            }
            this.transitionFuture = nextTransitionFuture;
        });
    }

    private void transitionToFollower(CompletableActorFuture<Void> transitionComplete) {
        this.actor.runOnCompletion(this.removeLeaderPartitionService(), (nothing, error) -> this.actor.runOnCompletion(this.installFollowerPartition(), (partition, err) -> transitionComplete.complete(null)));
    }

    private ActorFuture<Void> removeLeaderPartitionService() {
        if (this.startContext.hasService(this.leaderInstallRootServiceName)) {
            LOG.debug("Removing leader partition services for partition {}", (Object)this.partitionId);
            return this.startContext.removeService(this.leaderInstallRootServiceName);
        }
        return CompletableActorFuture.completed(null);
    }

    private ActorFuture<Void> installLeaderPartition(long leaderTerm) {
        LOG.debug("Installing leader partition service for partition {}", (Object)this.partitionId);
        BrokerRestoreServer restoreServer = new BrokerRestoreServer(this.communicationService, this.partitionId);
        Partition partition = new Partition(this.configuration, this.brokerCfg, this.clusterEventService, this.partitionId, RaftState.LEADER, restoreServer);
        CompositeServiceBuilder leaderInstallService = this.startContext.createComposite(this.leaderInstallRootServiceName);
        DistributedLogstreamPartition distributedLogstreamPartition = new DistributedLogstreamPartition(this.partitionId, leaderTerm);
        leaderInstallService.createService(LogStreamServiceNames.distributedLogPartitionServiceName((String)this.logName), (Service)distributedLogstreamPartition).dependency(ClusterBaseLayerServiceNames.ATOMIX_SERVICE, distributedLogstreamPartition.getAtomixInjector()).install();
        LeaderOpenLogStreamAppenderService leaderOpenLogStreamAppenderService = new LeaderOpenLogStreamAppenderService();
        leaderInstallService.createService(this.openLogStreamServiceName, (Service)leaderOpenLogStreamAppenderService).dependency(this.logStreamServiceName, leaderOpenLogStreamAppenderService.getLogStreamInjector()).dependency(LogStreamServiceNames.distributedLogPartitionServiceName((String)this.logName)).install();
        leaderInstallService.createService(this.leaderPartitionServiceName, (Service)partition).dependency(this.openLogStreamServiceName).dependency(this.logStreamServiceName, partition.getLogStreamInjector()).group(ClusterBaseLayerServiceNames.LEADER_PARTITION_GROUP_NAME).install();
        return leaderInstallService.install();
    }

    private ActorFuture<Partition> installFollowerPartition() {
        LOG.debug("Installing follower partition service for partition {}", (Object)this.partitionId);
        BrokerRestoreServer restoreServer = new BrokerRestoreServer(this.communicationService, this.partitionId);
        Partition partition = new Partition(this.configuration, this.brokerCfg, this.clusterEventService, this.partitionId, RaftState.FOLLOWER, restoreServer);
        return this.startContext.createService(this.followerPartitionServiceName, (Service)partition).dependency(this.logStreamServiceName, partition.getLogStreamInjector()).group(ClusterBaseLayerServiceNames.FOLLOWER_PARTITION_GROUP_NAME).install();
    }

    private ActorFuture<Void> removeFollowerPartitionService() {
        if (this.startContext.hasService(this.followerPartitionServiceName)) {
            LOG.debug("Removing follower partition service for partition {}", (Object)this.partitionId);
            return this.startContext.removeService(this.followerPartitionServiceName);
        }
        return CompletableActorFuture.completed(null);
    }
}

