/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.broker.clustering.base.partitions;

import io.atomix.cluster.MemberId;
import io.atomix.core.Atomix;
import io.atomix.protocols.raft.RaftServer;
import io.atomix.protocols.raft.partition.RaftPartition;
import io.zeebe.broker.Loggers;
import io.zeebe.broker.clustering.base.partitions.PartitionRoleChangeListener;
import io.zeebe.servicecontainer.Injector;
import io.zeebe.servicecontainer.Service;
import io.zeebe.servicecontainer.ServiceStartContext;
import io.zeebe.servicecontainer.ServiceStopContext;
import io.zeebe.util.sched.Actor;
import io.zeebe.util.sched.future.CompletableActorFuture;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.slf4j.Logger;

public class PartitionLeaderElection
extends Actor
implements Service<PartitionLeaderElection>,
Consumer<RaftServer.Role> {
    private static final Logger LOG = Loggers.CLUSTERING_LOGGER;
    private final Injector<Atomix> atomixInjector = new Injector();
    private final int partitionId;
    private final RaftPartition partition;
    private final List<PartitionRoleChangeListener> leaderElectionListeners;
    private RaftServer.Role raftRole;
    private long leaderTerm;
    private CompletableActorFuture<Void> startFuture;

    public PartitionLeaderElection(RaftPartition partition) {
        this.partition = partition;
        this.partitionId = (Integer)partition.id().id();
        this.leaderElectionListeners = new ArrayList<PartitionRoleChangeListener>();
    }

    public void start(ServiceStartContext startContext) {
        Atomix atomix = (Atomix)this.atomixInjector.getValue();
        MemberId memberId = atomix.getMembershipService().getLocalMember().id();
        this.startFuture = new CompletableActorFuture();
        startContext.getScheduler().submitActor((Actor)this);
        startContext.async(this.startFuture, true);
        LOG.info("Creating leader election for partition {} in node {}", (Object)this.partitionId, (Object)memberId);
    }

    protected void onActorStarted() {
        this.partition.addRoleChangeListener((Consumer)this);
        this.onRoleChange(this.partition.getRole());
        this.startFuture.complete(null);
    }

    @Override
    public void accept(RaftServer.Role newRole) {
        this.actor.run(() -> this.onRoleChange(newRole));
    }

    private void onRoleChange(RaftServer.Role newRole) {
        switch (newRole) {
            case LEADER: {
                if (this.raftRole == RaftServer.Role.LEADER) break;
                this.transitionToLeader(this.partition.term());
                break;
            }
            default: {
                if (this.raftRole != null && this.raftRole != RaftServer.Role.LEADER) break;
                this.transitionToFollower();
            }
        }
        LOG.debug("Partition role transitioning from {} to {}", (Object)this.raftRole, (Object)newRole);
        this.raftRole = newRole;
    }

    private void transitionToFollower() {
        this.leaderElectionListeners.forEach(l -> l.onTransitionToFollower(this.partitionId));
    }

    private void transitionToLeader(long term) {
        this.leaderTerm = term;
        this.leaderElectionListeners.forEach(l -> l.onTransitionToLeader(this.partitionId, term));
    }

    public void stop(ServiceStopContext stopContext) {
        this.partition.removeRoleChangeListener((Consumer)this);
        this.actor.close();
    }

    public PartitionLeaderElection get() {
        return this;
    }

    public int getPartitionId() {
        return this.partitionId;
    }

    public Injector<Atomix> getAtomixInjector() {
        return this.atomixInjector;
    }

    public void addListener(PartitionRoleChangeListener listener) {
        this.actor.run(() -> {
            this.leaderElectionListeners.add(listener);
            if (this.raftRole == RaftServer.Role.LEADER) {
                listener.onTransitionToLeader(this.partitionId, this.leaderTerm);
            } else {
                listener.onTransitionToFollower(this.partitionId);
            }
        });
    }

    public void removeListener(PartitionRoleChangeListener listener) {
        this.actor.run(() -> this.leaderElectionListeners.remove(listener));
    }
}

